# -*- coding: ISO-8859-1 -*-
""" capellaScript -- Copyright (c) 2004-2015 Peter Becker
>>> Ziach_A : Tabulaturschrift fr Steirische Harmonika
    Umsetzen von Noten in die Tabulaturschrift fr Steirische Harmonika.
    -> Schritt 1 von 3||
    Translation of dotted notes into Griffschrift for Steirische.||
    -> Step 1 of 3||
    
    Achtung ( Attention ): |
    - Bass-Definitionen in Ziach_DEF.py|
    - Language in Ziach_tr.py||
    
    Bei Problemen bitte eine Mail an |
    (In case of problems, please email ):|peter_becker@freenet.de
<<<

History:  16.07.04 - Version 1.0            
          29.11.04 - Version 2.0 Split into 3 Modules 
          27.12.05 - Version 3.0 National Language Support
          08.05.09 - Version 4.0, .DEF und .MSG als Python Datei
          09.05.09 - Sprachauswahl hinzugefgt 4.1.0
          18.10.10 - Versionsanzeige eingefgt 4.1.1
          11.11.10 - 4.1.2 wg. Ziach B
          17.03.11 - 4.1.3 wg. Ziach B
          18.11.11 - 4.1.4 Warnung und Abbruch, wenn leeres System gefunden wurde
          10.03.12 - 4.1.5 durch Ziach_B
          08.05.12 - V4.1.6 wegen Ziach_C
          07.06.12 - V4.1.7 Mehrfachakkorde lschen bis auf den letzten ( nur transposable ) um Absturz in Ziach C zu vermeiden
          07.07.12 - V4.1.8 wegen Ziach_C
          08.07.12 - V4.1.9 wegen Ziach_C
          09.07.12 - V4.1.10 wegen Ziach_C
          10.07.12 - V4.1.11 wegen Ziach_C
          03.08.12 - V4.1.12 wegen Ziach_C
          09.08.12 - V4.1.13 wegen Ziach_C
          01.08.13 - V4.1.14 Doppeldominant wird bei Einfachtext nicht erkannt, wenn nicht als Septime geschrieben
          21.09.14 - V4.1.15 wegen Ziach_B
          26.03.15 - V4.2.0  Umstellung auf Capella Multilanguage Support
          31.07.15 - V4.2.1  Absturz wenn erster Akkord nicht gltig ist
"""

# TAG Liste
# 2086-31 Druck - innen        Reihe C - G-Dur
# 2086-32 Druck - mitte        Reihe B - D-Dur
# 2086-33 Druck - aussen       Reihe A - A-Dur
# 2086-34 Druck - ganz innen   Reihe F - C-Dur
# 2086-41 Zug   - innen        Reihe C - G-Dur
# 2086-42 Zug   - mitte        Reihe B - D-Dur
# 2086-43 Zug   - aussen       Reihe A - A-Dur
# 2086-44 Zug   - ganz innen   Reihe F - C-Dur 
# 2086-50 Akkordbezeichnung
# 2086-51 Bass ID
# 2086-52 Instrumententyp
# 2086-53 Bassbelegung

Version = '4.2.1 - 31.7.2015'

german = ("de", {
    "msgA01"   : 'Element : items ',
    "msgA02"   : 'nicht untersttztes Element : ', 
    "msgA03"   : '3-Reiher ', 
    "msgA04"   : '4-Reiher ',
    "msgA05"   : 'Auswahl des Bass-Systems',
    "msgA06"   : 'Bass-System',
    "msgA07"   : 'Fr welche Reihe soll transponiert werden ?',
    "msgA08"   : 'Reihe - A    ( aussen )',
    "msgA09"   : 'Reihe - B    ( mitte )',
    "msgA10"   : 'Reihe - C    ( innen )',
    "msgA11"   : 'Reihe - F(D) ( ganz innen )',
    "msgA12"   : 'Reihe',
    "msgA13"   : 'Reihe - B/C    ( mitte/innen )',
    "msgA14"   : 'Reihe - A/B    ( aussen/mitte )',
    "msgA15"   : 'Reihe - C/F(D) ( innen/ganz innen )',
    "msgA16"   : 'Reihen',
    "msgA17"   : 'Fr welche Reihen soll transponiert werden ?',
    "msgA18"   : 'Reihe - A/C      ( aussen/innen )',
    "msgA19"   : 'Reihe - B/F      ( mitte/ganz innen )',
    "msgA20"   : 'Reihe - A/B/C    ( aussen/mitte/innen )',
    "msgA21"   : 'Reihe - B/C/F(D) ( mitte/innen/ganz innen )',
    "msgA22"   : '- Der Abstand der Tonarten ist zu gro',
    "msgA23"   : 'Partitur entspricht nicht den Vorgaben.',
    "msgA24"   : '- Akkordangaben fehlen',
    "msgA25"   : 'Tastenbelegung',
    "msgA26"   : 'Taktangabe fehlt. Das fhrt zu Problemen in Ziach_C.',
    "msgA27"   : 'Leeres System gefunden. Bitte entfernen. Systennummer = '
    })

try:
    from Ziach_tr import translations
    translations.append(german)
    setLanguages(translations)
except:
    #messageBox('Stop','stop')
    def tr(s):
        return german[1].get(s, "???")

#-------------------------------------------------------------------
    
import xml.dom, tempfile
from caplib.capDOM import ScoreChange
from xml.dom.minidom import NodeList, Node, Element
    
checkCapVersion(5,1,5)
doc = [] # parentNode von score


def analyzeAkkord(chord):
    akkordText = ''
    for transposable in chord.getElementsByTagName('transposable'):
        base = transposable.getAttribute('base')
        for drawObj in transposable.getElementsByTagName('drawObj'):
            if drawObj.hasAttribute('base') and drawObj.getAttribute('base') == base:
                for text in drawObj.getElementsByTagName('text'):
                    t = text.getElementsByTagName('content')[0].firstChild.nodeValue
                    if 'capella' in text.getElementsByTagName('font')[0].getAttribute('face'):
                        if 'Q' in t: t = 'b'
                        elif 'S' in t: t = '#'
                    akkordText = akkordText + t
                # Korrektur fr deutsche Akkordbezeichnung B -> Bb
                if base == 'Bb':
                    if string.lower(akkordText[0:1]) == 'b' and string.lower(akkordText[0:2]) <> 'bb':
                        akkordText = 'Bb' + akkordText[1:]
                break
        break
    return akkordText
    
def welcheReihe(tArt,tList,okeyw):

    #messageBox('Liste',str(tArt) + '\n' + str(tList) + '\n' + str(okeyw))          
    if tArt == 'T' and len(tList) == 4:        # 4 Tonarten nebeneinander
        if str(tList[0]) == str(okeyw):
            wo = 'Z'
        elif str(tList[1]) == str(okeyw):
            wo = 'I'
        elif str(tList[2]) == str(okeyw):
            wo = 'M'
        elif str(tList[3]) == str(okeyw):
            wo = 'A'
                        
    elif tArt == 'Z' and len(tList) == 3:      # 3 Tonarten nebeneinander GI/I/M
        if tList[1] - tList[0] == 1:            
            if str(tList[0]) == str(okeyw):
                wo = 'Z'
            elif str(tList[1]) == str(okeyw):
                wo = 'I'
            elif str(tList[2]) == str(okeyw):
                wo = 'M'

    elif tArt == 'I' and len(tList) == 3:      # 3 Tonarten nebeneinander I/M/A
        if tList[1] - tList[0] == 1:            
            if str(tList[0]) == str(okeyw):
                wo = 'I'
            elif str(tList[1]) == str(okeyw):
                wo = 'M'
            elif str(tList[2]) == str(okeyw):
                wo = 'A'

    elif tArt == 'T' and len(tList) == 3:      # 3 Tonarten nicht nebeneinander
        if tList[1] - tList[0] == 1:           # GI/I/A
            if str(tList[0]) == str(okeyw):
                wo = 'Z'
            elif str(tList[1]) == str(okeyw):
                wo = 'I'
            elif str(tList[2]) == str(okeyw):
                wo = 'A'
        else:                                  # GI/M/A
            if str(tList[0]) == str(okeyw):
                wo = 'Z'
            elif str(tList[1]) == str(okeyw):
                wo = 'M'
            elif str(tList[2]) == str(okeyw):
                wo = 'A'
           
    elif tArt == 'Z' and len(tList) == 2:      
        if tList[1] - tList[0] == 1:           # 2 Tonarten nebeneinander GI/I   
            if str(tList[0]) == str(okeyw):
                wo = 'Z'
            elif str(tList[1]) == str(okeyw):
                wo = 'I'
        else:
            if str(tList[0]) == str(okeyw):    # 2 Tonarten nicht nebeneinander, Start GI
                wo = 'Z'
            elif str(tList[1]) == str(okeyw):
                wo = 'M'
    elif tArt == 'I' and len(tList) == 2:      # 2 Tonarten nebeneinander I/M
        if tList[1] - tList[0] == 1:           
            if str(tList[0]) == str(okeyw):
                wo = 'I'
            elif str(tList[1]) == str(okeyw):
                wo = 'M'
        else:
            if str(tList[0]) == str(okeyw):    # 2 Tonarten nicht nebeneinander, Start I/A
                wo = 'I'
            elif str(tList[1]) == str(okeyw):
                wo = 'A'
    elif tArt == 'M' and len(tList) == 2:      # 2 Tonarten nebeneinander M/A
        if tList[1] - tList[0] == 1:           
            if str(tList[0]) == str(okeyw):
                wo = 'M'
            elif str(tList[1]) == str(okeyw):
                wo = 'A'
    elif tArt == 'T' and len(tList) == 2:      # 2 Tonarten nicht nebeneinander GI/A
        if str(tList[0]) == str(okeyw):
            wo = 'Z'
        elif str(tList[1]) == str(okeyw):
            wo = 'A'
    
    else: wo = tArt                            # 1 Tonart, Lage vorgewhlt

    return wo

def transposeAcc(id):           # T=alles, Z=ganz innen(C), I=innen(G), M=mitte(D), A=aussen(A)
                                # Akkordbezeichnungen nach C, G, D oder A-Dur konvertieren und danach in
                                # das Rosenzopf System umwandeln
                                
    global tArt, tList, okeyw, dodmerker, ZA_flag, instrument, gb

    # Dur Akkorde der einzelnen Tonarten
    #messageBox('Interface','tArt = ' + str(tArt) + '\ntList = ' + str(tList))
    TransposeList  = dict(
                      P0 = dict(T='C'  , M2='Dm' , M3='Em' ,S='F' , D='G' , D7='G7'  , M5='E7' , M6='Am' , V7='B-' , DD='D7') ,
                      P1 = dict(T='G'  , M2='Am' , M3='Bm' ,S='C' , D='D' , D7='D7'  , M5='B7' , M6='Em' , V7='F#-', DD='A7') ,
                      P2 = dict(T='D'  , M2='Em' , M3='F#m',S='G' , D='A' , D7='A7'  , M5='F#7', M6='Bm' , V7='C#-', DD='E7') ,
                      P3 = dict(T='A'  , M2='Bm' , M3='C#m',S='D' , D='E' , D7='E7'  , M5='C#7', M6='F#m', V7='G#-', DD='B7') ,
                      P4 = dict(T='E'  , M2='F#m', M3='G#m',S='A' , D='H' , D7='B7'  , M5='G#7', M6='C#m', V7='D#-', DD='F#7'),
                      P5 = dict(T='B'  , M2='C#m', M3='D#m',S='E' , D='F#', D7='F#7' , M5='D#7', M6='G#m', V7='A#-', DD='C#7'),
                      P6 = dict(T='F#' , M2='G#m', M3='A#m',S='H' , D='C#', D7='C#7' , M5='A#7', M6='D#m', V7='E#-', DD='G#7'),
                      P7 = dict(T='C#' , M2='D#m', M3='E#m',S='F#', D='G#', D7='G#7' , M5='E#7', M6='A#m', V7='B#-', DD='D#7'),
                      M1 = dict(T='F'  , M2='Gm' , M3='Am' ,S='Bb', D='C' , D7='C7'  , M5='A7' , M6='Dm',  V7='E-' , DD='G7' ),
                      M2 = dict(T='Bb' , M2='Cm' , M3='Dm' ,S='Eb', D='F' , D7='F7'  , M5='D7' , M6='Gm',  V7='A-' , DD='C7' ),
                      M3 = dict(T='Eb' , M2='Fm' , M3='Gm' ,S='Ab', D='Bb', D7='Bb7' , M5='G7' , M6='Cm',  V7='D-' , DD='F7' ),
                      M4 = dict(T='Ab' , M2='Bbm', M3='Cm' ,S='Db', D='Eb', D7='Eb7' , M5='C7' , M6='Fm',  V7='G-' , DD='Bb7'),
                      M5 = dict(T='Db' , M2='Ebm', M3='Fm' ,S='Gb', D='Ab', D7='Ab7' , M5='F7' , M6='Bbm', V7='C-' , DD='Eb7'),
                      M6 = dict(T='Gb' , M2='Abm', M3='Bbm',S='Cb', D='Db', D7='Db7' , M5='Bb7', M6='Ebm', V7='F-' , DD='Ab7'),
                      M7 = dict(T='Cb' , M2='Dbm', M3='Ebm',S='Fb', D='Gb', D7='Gb7' , M5='Eb7', M6='Abm', V7='Bb-', DD='Db7')
                      )

    #xx = transposeList['M1']['T']  #so wird das Dictionary abgefragt

    valChord = ['C','D','E','F','G','A','B','H','C#','D#','E#','F#','G#','A#','B#','H#','Cis','Dis','Eis','Fis',
                'Gis','Ais','Bis','His','Cb','Db','Eb','Fb','Gb','Ab','Bb','Ces','Des','Es','Fes','Ges','As',
                'Cm','Dm','Em','Fm','Gm','Am','Bm','Hm','C#m','D#m','E#m','F#m','G#m','A#m','B#m','H#m','Cism',
                'Dism','Eism','Fism','Gism','Aism','Bism','Hism','Cbm','Dbm','Ebm','Fbm','Gbm','Abm','Bbm',
                'Cesm','Desm','Esm','Fesm','Gesm','Asm','C7','D7','E7','F7','G7','A7','B7','H7','C#7','D#7',
                'E#7','F#7','G#7','A#7','B#7','H#7','Cis7','Dis7','Eis7','Fis7','Gis7','Ais7','Bis7','His7',
                'Cb7','Db7','Eb7','Fb7','Gb7','Ab7','Bb7','Ces7','Des7','Es7','Fes7','Ges7','As7','R','Z','-',
                'C-','D-','E-','F-','G-','A-','B-','H-','C#-','D#-','E#-','F#-','G#-','A#-','B#-','H#-','Cis-',
                'Dis-','Eis-','Fis-','Gis-','Ais-','Bis-','His-','Cb-','Db-','Eb-','Fb-','Gb-','Ab-','Bb-',
                'Ces-','Des-','Es-','Fes-','Ges-','As-']
    
    setInstr  = 0
    dodmerker = 0
    type      = 'text'
    txt       = ' '
    for no in activeScore().noteObjs():
        if no.isChord() or no.isRest():
            i = no.nDrawObjs()-1
            while i >= 0:
                d = no.drawObj(i)
                if d['type'] == 'transposable':
                    type = 'trans'
                    break
                else:
                    i -= 1
            if type == 'trans':
                break
            
    for no in activeScore().noteObjs():
        chordcount = 0
        if no.isChord()or no.isRest():
            keyw  = str(no.curKey())
            okeyw = keyw
            if keyw[0:1] == '-':
               keyw = 'M' + str(keyw[1])
            else :
                keyw = 'P' + str(keyw)
 
            i = no.nDrawObjs()-1
            #messageBox('Fehler',str(i))
            
            while i >= 0:
                #messageBox('cc',str(chordcount))
                if chordcount <> 0:              # Mehrfachakkorde an einer Note lschen bis auf den letzten
                #    no.deleteDrawObj(i)
                    d = no.drawObj(i)
                    #messageBox('DO',str(d))
                    if d['type'] == 'transposable' and type == 'trans':
                       # messageBox('Delete',str(d))
                        no.deleteDrawObj(i)
                        #chordcount=chordcount-1
                        
                spec = 'X'
                d = no.drawObj(i)
                #('TRANS',str(d))
                if d['type'] == 'transposable' and type == 'trans':
                    ot    = '0'
                    nRef = d['nRefNote']
                    relN = RelDiatonicNote.fromCircleOfFifth(nRef)
                    txt = str(relN)
                    #messageBox('TRANS',str(nRef) + '    ' + str(txt))
                    rc = isMoll(no)               # prfen ob Moll
                    #messageBox('TRANS',str(nRef) + '    ' + str(txt) + '     ' + str(rc))
                    if rc == 1:                   # wenn ja,
                        txt = txt + 'm'           # dann Akkord bernehmen
                    if rc == 2:                   # wenn ja,
                        txt = txt + '-'           # dann Akkord bernehmen
                    chordcount = chordcount + 1     
                    #messageBox('TRANS',str(nRef) + '    ' + str(txt) + '    ' + str(rc))
                    #messageBox('VOR',str(d))    
                elif d['type'] == 'text' and type == 'text':
                    #messageBox('TEXT',str(d))
                    ot  = 1
                    txt = d['content']
                    if txt == 'R':
                        tag   = '2086-32'
                        spec  = 'R'
                        direc = 'D'
                    if txt == 'Z':
                        tag = '2086-42'
                        spec  = 'Z'
                        direc = 'Z'
                    #messageBox('TEXT',str(d) + '\n' + str(txt) + '\n' + str(tag) + '\n' + str(spec))

                elif d['type'] == 'text' and d['content'] == 'R':
                    #messageBox('XTEXT',str(d))
                    txt = '-'
                    ot  = 1
                    tag   = '2086-32'
                    spec  = 'R'
                    direc = 'D'

                elif d['type'] == 'text' and d['content'] == 'Z':
                    #messageBox('XTEXT',str(d))
                    txt = '-'
                    ot = 1
                    tag = '2086-42'
                    spec  = 'Z'
                    direc = 'Z'
                    #messageBox('TEXT',str(d) + '\n' + str(txt) + '\n' + str(tag) + '\n' + str(spec))

                else:
                    i -= 1
                    continue

                if d['type'] == 'text' and txt not in valChord:                  # alles was kein Akkord ist berspringen
                    #messageBox('suppress',str(txt))
                    i -= 1
                    continue
                
                #messageBox('transKEY',str(txt) + '\n' + str(keyw))               # liefert die Akkordstufen der aktuellen Tonart

                ton = TransposeList[keyw]['T']    # Tonika
                m2  = TransposeList[keyw]['M2']   # Mollakkord der 2. Stufe
                m3  = TransposeList[keyw]['M3']   # Mollakkord der 3. Stufe
                sub = TransposeList[keyw]['S']    # Subdominante 
                dom = TransposeList[keyw]['D']    # Dominante
                do7 = TransposeList[keyw]['D7']   # Dominantsept
                m6  = TransposeList[keyw]['M6']   # Mollakkord der 6. Stufe
                v7  = TransposeList[keyw]['V7']   # Vermindert der 7. Stufe
                dod = TransposeList[keyw]['DD']   # Doppeldominante
                m5  = TransposeList[keyw]['M5']   # Septakkord 5. Stufe bei Moll Tonleiter
                 
                wo = welcheReihe(tArt,tList,okeyw)# Zuordnung der Reihe

                t = dict(type = 'text', x = 0, y = 5.0,
                         font = dict(height = 12, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))

                #messageBox('KEY','txt = ' + str(txt) + '  wo = ' + str(wo) + '\n' + str(keyw) + ' : ' + str(ton) + str(sub) + str(do7))

                if txt[0:1] == 'H': txt = 'B' + txt[1] 
                mtx = txt
                txt = txt[0:2]
                ton = ton[0:2]
                sub = sub[0:2]
                dom = dom[0:2]
                do7 = do7[0:3]
                if ot == '0': dod = dod[0:1]
                else: dod = dod
                m2  = m2
                m3  = m3
                m6  = m6
                v7  = v7
                m5  = m5

                #messageBox('V7','*'+str(v7)+'*'+str(mtx)+'*')
                #messageBox('Auswertung','txt=' + str(txt) + '\nton=' + str(ton) + '\nm2=' + str(m2) + '\nm3=' + str(m3) +
                #           '\nsub=' + str(sub) + '\ndom=' + str(dom) + '\ndo7=' + str(do7) + '\nm6=' + str(m6) +
                #           '\nv7=' + str(v7) + '\ndod=' + str(dod) + '\nmtx=' + str(mtx) + '\nm5=' + str(m5)) 
                #messageBox('KEY','txt = ' + str(txt) + '\nmtx = ' + str(mtx) + '\nwo = ' + str(wo) + '\nton = ' + str(ton) + '\nsub = ' + str(sub) + '\ndom = ' + str(dom) + '\ndo7 = ' + str(do7) + '\ndod = ' + str(dod) + '\nm2 = ' + str(m2))
                #messageBox('rosenzopf1',str(id))
                #messageBox('rosenzopf2',str(chord) + str(direc))
                
                if txt == ton:
                    #messageBox('TXT=TON',str(wo))
                    if  wo == 'Z':            
                        chord = bassList[id]['F']['gC']      # Reihe-F, C-Dur
                        direc = bassList[id]['F']['rC']
                        acc   = 'C'
                        if direc == 'D':tag = '2086-34'      # auf Druck spielen
                        else:tag = '2086-44'                 # auf Zug spielen 
                    elif wo == 'I':
                        chord = bassList[id]['C']['gG']      # Reihe-C, G-Dur
                        direc = bassList[id]['C']['rG']
                        acc   = 'G'
                        if direc == 'D':tag = '2086-31'      # auf Druck spielen
                        else:tag = '2086-41'                 # auf Zug spielen
                    elif  wo == 'M':
                        chord = bassList[id]['B']['gD']      # Reihe-B, D-Dur
                        direc = bassList[id]['B']['rD']
                        acc   = 'D'
                        if direc == 'D':tag = '2086-32'      # auf Druck spielen
                        else:tag = '2086-42'                 # auf Zug spielen
                    elif  wo == 'A':
                        chord = bassList[id]['A']['gA']      # Reihe-A, A-Dur
                        direc = bassList[id]['A']['rA']
                        acc   = 'A'
                        if direc == 'D':tag = '2086-33'      # auf Druck spielen
                        else:tag = '2086-43'                 # auf Zug spielen
                    dodmerker = 0
                
                elif txt == sub:
                    #messageBox('TXT=SUB',str(wo))
                    if  wo == 'Z':            
                        chord = bassList[id]['F']['gF']      # Reihe-F, F-Dur
                        direc = bassList[id]['F']['rF']
                        acc   = 'F'
                        if direc == 'D':tag = '2086-34'      # auf Druck spielen
                        else:tag = '2086-44'                 # auf Zug spielen 
                    elif wo == 'I':
                        chord = bassList[id]['C']['gC']      # Reihe-C, C-Dur
                        direc = bassList[id]['C']['rC']
                        acc   = 'C'
                        if direc == 'D':tag = '2086-31'      # auf Druck spielen
                        else:tag = '2086-41'                 # auf Zug spielen
                    elif  wo == 'M':
                        chord = bassList[id]['B']['gG']      # Reihe-B, G-Dur
                        direc = bassList[id]['B']['rG']
                        acc   = 'G'
                        if direc == 'D':tag = '2086-32'      # auf Druck spielen
                        else:tag = '2086-42'                 # auf Zug spielen
                    elif  wo == 'A':
                        chord = bassList[id]['A']['gD']      # Reihe-A, D-Dur
                        direc = bassList[id]['A']['rD']
                        acc   = 'D'
                        if direc == 'D':tag = '2086-33'      # auf Druck spielen
                        else:tag = '2086-43'                 # auf Zug spielen
                    dodmerker = 0
                    
                elif txt == dom and mtx == dom:
                    #messageBox('TXT=DOM',str(wo) + ' ** ' + str(dodmerker))
                    if wo == 'Z' and dodmerker == 0:
                        chord = bassList[id]['F']['gG']      # Reihe-F, G-Dur
                        direc = bassList[id]['F']['rG']
                        acc   = 'G'
                        if direc == 'D':tag = '2086-34'      # auf Druck spielen
                        else:tag = '2086-44'                 # auf Zug spielen
                    elif wo == 'Z' and dodmerker == 1:
                        chord = bassList[id]['F']['gGD']     # Reihe-F, G-Dur nach Doppeldominante
                        direc = bassList[id]['F']['rGD']
                        acc   = 'Gx'
                        if direc == 'D':tag = '2086-34'      # auf Druck spielen
                        else:tag = '2086-44'                 # auf Zug spielen 
                    elif  wo == 'M'and dodmerker == 0:
                        chord = bassList[id]['B']['gA']      # Reihe-B, A-Dur
                        direc = bassList[id]['B']['rA']
                        acc   = 'A'
                        if direc == 'D':tag = '2086-32'      # auf Druck spielen
                        else:tag = '2086-42'                 # auf Zug spielen
                    elif  wo == 'M'and dodmerker == 1:
                        chord = bassList[id]['B']['gAD']     # Reihe-B, A-Dur nach Doppeldominante
                        direc = bassList[id]['B']['rAD']
                        acc   = 'Ax'
                        if direc == 'D':tag = '2086-32'      # auf Druck spielen
                        else:tag = '2086-42'                 # auf Zug spielen 
                    if wo == 'I' and dodmerker == 0:
                        chord = bassList[id]['C']['gD']      # Reihe-C, D-Dur
                        direc = bassList[id]['C']['rD']
                        acc   = 'D'
                        if direc == 'D':tag = '2086-31'      # auf Druck spielen
                        else:tag = '2086-41'                 # auf Zug spielen
                    elif wo == 'I' and dodmerker == 1:
                        chord = bassList[id]['C']['gDD']     # Reihe-C, D-Dur  nach Doppeldominante
                        direc = bassList[id]['C']['rDD']
                        acc   = 'Dx'
                        if direc == 'D':tag = '2086-31'      # auf Druck spielen
                        else:tag = '2086-41'                 # auf Zug spielen
                    elif  wo == 'A' and dodmerker == 0:
                        chord = bassList[id]['A']['gE']      # Reihe-A, E-Dur   
                        direc = bassList[id]['A']['rE']
                        acc   = 'E'
                        if direc == 'D':tag = '2086-33'      # auf Druck spielen
                        else:tag = '2086-43'                 # auf Zug spielen
                    elif  wo == 'A' and dodmerker == 1:
                        chord = bassList[id]['A']['gED']     # Reihe-A, E-Dur  nach Doppeldominante
                        direc = bassList[id]['A']['rED']
                        acc   = 'Ex'
                        if direc == 'D':tag = '2086-33'      # auf Druck spielen
                        else:tag = '2086-43'                 # auf Zug spielen

                elif mtx == do7:
                    #messageBox('TXT=DO7',str(wo))
                    if wo == 'Z':
                        chord = bassList[id]['F']['gG7']     # Reihe-F, G7-Dur
                        direc = bassList[id]['F']['rG7']
                        acc   = 'G7'
                        if direc == 'D':tag = '2086-34'      # auf Druck spielen
                        else:tag = '2086-44'                 # auf Zug spielen
                    elif wo == 'I':
                        chord = bassList[id]['C']['gD7']     # Reihe-C, D7-Dur
                        direc = bassList[id]['C']['rD7']
                        acc   = 'D7'
                        if direc == 'D':tag = '2086-31'      # auf Druck spielen
                        else:tag = '2086-41'                 # auf Zug spielen
                    elif  wo == 'M':
                        chord = bassList[id]['B']['gA7']     # Reihe-B, A7-Dur
                        direc = bassList[id]['B']['rA7']
                        acc   = 'A7'
                        if direc == 'D':tag = '2086-32'      # auf Druck spielen
                        else:tag = '2086-42'                 # auf Zug spielen
                    elif  wo == 'A':
                        chord = bassList[id]['A']['gE7']     # Reihe-A, E7-Dur
                        direc = bassList[id]['A']['rE7']
                        acc   = 'E7'
                        if direc == 'D':tag = '2086-33'      # auf Druck spielen
                        else:tag = '2086-43'                 # auf Zug spielen
                    dodmerker = 0

                elif mtx == v7:
                    #messageBox('MTX=V7',str(wo))
                    if  wo == 'Z':            
                        chord = bassList[id]['F']['gB-']     # Reihe-F, H-vermindert
                        direc = bassList[id]['F']['rB-']
                        acc   = 'B-'
                        if direc == 'D':tag = '2086-34'      # auf Druck spielen
                        else:tag = '2086-44'                 # auf Zug spielen
                    elif wo == 'I':
                        chord = bassList[id]['C']['gF#-']    # Reihe-C, F#-vermindert
                        direc = bassList[id]['C']['rF#-']
                        acc   = 'F#-'
                        #messageBox('ID',str(id) + '*' + str(chord))
                        if direc == 'D':tag = '2086-31'      # auf Druck spielen
                        else:tag = '2086-41'                 # auf Zug spielen
                    elif  wo == 'M':
                        chord = bassList[id]['B']['gC#-']    # Reihe-B, C#-vermindert
                        direc = bassList[id]['B']['rC#-']
                        acc   = 'C#-'
                        if direc == 'D':tag = '2086-32'      # auf Druck spielen
                        else:tag = '2086-42'                 # auf Zug spielen
                    elif  wo == 'A':
                        chord = bassList[id]['A']['gG#-']    # Reihe-A, G#-vermindert
                        direc = bassList[id]['A']['rG#-']
                        acc   = 'G#-'
                        if direc == 'D':tag = '2086-33'      # auf Druck spielen
                        else:tag = '2086-43'                 # auf Zug spielen
                    dodmerker = 0
                else:                                        # Falls nicht gefunden sicherheitshalber
                    chord = '-'                              # auf unbekannt setzen. Eine 2. Chance gibts
                    acc   = mtx                              # bei Moll und der Doppeldominante
                    
                if mtx[1:] == '7':                           # Septime fr 5. Stufe in Moll erzeugen falls nicht vorhanden
                    mtx1 = mtx
                else:
                    mtx1 = mtx + '7'
                #messageBox('MTX',str(mtx1))
                #messageBox('MTX',str(dod) + " ** " + str(mtx) + ' ** ' + str(mtx1))
                if mtx == m2:
                    #messageBox('MTX=M2',str(wo))
                    if  wo == 'Z':            
                        chord = bassList[id]['F']['gDm']     # Reihe-F, D-Moll
                        direc = bassList[id]['F']['rDm']
                        acc   = 'Dm'
                        if direc == 'D':tag = '2086-34'      # auf Druck spielen
                        else:tag = '2086-44'                 # auf Zug spielen
                    elif wo == 'I':
                        chord = bassList[id]['C']['gAm']     # Reihe-C, A-Moll
                        direc = bassList[id]['C']['rAm']
                        acc   = 'Am'
                        if direc == 'D':tag = '2086-31'      # auf Druck spielen
                        else:tag = '2086-41'                 # auf Zug spielen
                    elif  wo == 'M':
                        chord = bassList[id]['B']['gEm']     # Reihe-B, E-Moll
                        direc = bassList[id]['B']['rEm']
                        acc   = 'Em'
                        if direc == 'D':tag = '2086-32'      # auf Druck spielen
                        else:tag = '2086-42'                 # auf Zug spielen
                    elif  wo == 'A':
                        chord = bassList[id]['A']['gBm']      # Reihe-A, H-Moll
                        direc = bassList[id]['A']['rBm']
                        acc   = 'Bm'
                        if direc == 'D':tag = '2086-33'      # auf Druck spielen
                        else:tag = '2086-43'                 # auf Zug spielen
                    dodmerker = 0
                    t['content'] = chord
                    t['tag'] = tag

                elif mtx == m3:
                    #messageBox('MTX=M3',str(wo))
                    if  wo == 'Z':            
                        chord = bassList[id]['F']['gEm']     # Reihe-F, E-Moll
                        direc = bassList[id]['F']['rEm']
                        acc   = 'Em'
                        if direc == 'D':tag = '2086-34'      # auf Druck spielen
                        else:tag = '2086-44'                 # auf Zug spielen
                    elif wo == 'I':
                        chord = bassList[id]['C']['gBm']     # Reihe-C, H-Moll
                        direc = bassList[id]['C']['rBm']
                        acc   = 'Bm'
                        if direc == 'D':tag = '2086-31'      # auf Druck spielen
                        else:tag = '2086-41'                 # auf Zug spielen
                    elif  wo == 'M':
                        chord = bassList[id]['B']['gF#m']    # Reihe-B, F#-Moll
                        direc = bassList[id]['B']['rF#m']
                        acc   = 'F#m'
                        if direc == 'D':tag = '2086-32'      # auf Druck spielen
                        else:tag = '2086-42'                 # auf Zug spielen
                    elif  wo == 'A':
                        chord = bassList[id]['A']['gC#m']    # Reihe-A, C#-Moll
                        direc = bassList[id]['A']['rC#m']
                        acc   = 'C#m'
                        if direc == 'D':tag = '2086-33'      # auf Druck spielen
                        else:tag = '2086-43'                 # auf Zug spielen
                    dodmerker = 0

                elif mtx1 == m5:
                    #messageBox('MTX=M5',str(wo) + '\n' + str(id))
                    if wo == 'Z':
                        chord = bassList[id]['F']['gE7']     # Reihe-F, E7-Dur
                        direc = bassList[id]['F']['rE7']
                        acc   = 'E7'
                        if direc == 'D':tag = '2086-34'      # auf Druck spielen
                        else:tag = '2086-44'                 # auf Zug spielen
                    elif wo == 'I':
                        chord = bassList[id]['C']['gB7']     # Reihe-C, B7-Dur
                        direc = bassList[id]['C']['rB7']
                        acc   = 'B7'
                        if direc == 'D':tag = '2086-31'      # auf Druck spielen
                        else:tag = '2086-41'                 # auf Zug spielen
                    elif  wo == 'M':
                        chord = bassList[id]['B']['gF#7']     # Reihe-B, F#7-Dur
                        direc = bassList[id]['B']['rF#7']
                        acc   = 'F#7'
                        if direc == 'D':tag = '2086-32'      # auf Druck spielen
                        else:tag = '2086-42'                 # auf Zug spielen
                    elif  wo == 'A':
                        chord = bassList[id]['A']['gC#7']     # Reihe-A, C#7-Dur
                        direc = bassList[id]['A']['rC#7']
                        acc   = 'C#7'
                        if direc == 'D':tag = '2086-33'      # auf Druck spielen
                        else:tag = '2086-43'                 # auf Zug spielen        

                elif mtx == m6:
                    #messageBox('MTX=M6',str(wo))
                    if  wo == 'Z':            
                        chord = bassList[id]['F']['gAm']     # Reihe-F, A-Moll
                        direc = bassList[id]['F']['rAm']
                        acc   = 'Am'
                        if direc == 'D':tag = '2086-34'      # auf Druck spielen
                        else:tag = '2086-44'                 # auf Zug spielen
                    elif wo == 'I':
                        chord = bassList[id]['C']['gEm']     # Reihe-C, E-Moll
                        direc = bassList[id]['C']['rEm']
                        acc   = 'Em'
                        if direc == 'D':tag = '2086-31'      # auf Druck spielen
                        else:tag = '2086-41'                 # auf Zug spielen
                    elif  wo == 'M':
                        chord = bassList[id]['B']['gBm']     # Reihe-B, H-Moll
                        direc = bassList[id]['B']['rBm']
                        acc   = 'Bm'
                        if direc == 'D':tag = '2086-32'      # auf Druck spielen
                        else:tag = '2086-42'                 # auf Zug spielen
                    elif  wo == 'A':
                        chord = bassList[id]['A']['gF#m']    # Reihe-A, F#-Moll
                        direc = bassList[id]['A']['rF#m']
                        acc   = 'F#m'
                        if direc == 'D':tag = '2086-33'      # auf Druck spielen
                        else:tag = '2086-43'                 # auf Zug spielen
                    dodmerker = 0

                elif mtx == dod or mtx1 == dod:
                    #messageBox('MTX=DOD',str(wo))
                    dodmerker = 1
                    if wo == 'Z':
                        chord = bassList[id]['F']['gD7']     # Reihe-F, D7-Dur
                        direc = bassList[id]['F']['rD7']
                        acc   = 'D7'
                        if direc == 'D':tag = '2086-34'      # auf Druck spielen
                        else:tag = '2086-44'                 # auf Zug spielen
                    elif wo == 'I':
                        chord = bassList[id]['C']['gA7']     # Reihe-C, A7-Dur
                        direc = bassList[id]['C']['rA7']
                        acc   = 'A7'
                        if direc == 'D':tag = '2086-31'      # auf Druck spielen
                        else:tag = '2086-41'                 # auf Zug spielen
                    elif  wo == 'M':
                        chord = bassList[id]['B']['gE7']     # Reihe-B, E7-Dur
                        direc = bassList[id]['B']['rE7']
                        acc   = 'E7'
                        if direc == 'D':tag = '2086-32'      # auf Druck spielen
                        else:tag = '2086-42'                 # auf Zug spielen
                    elif  wo == 'A':
                        chord = bassList[id]['A']['gB7']     # Reihe-A, H7-Dur
                        direc = bassList[id]['A']['rB7']
                        acc   = 'B7'
                        if direc == 'D':tag = '2086-33'      # auf Druck spielen
                        else:tag = '2086-43'                 # auf Zug spielen

                                   
                #messageBox('CHORD',str(chord))
                if chord == '-':
                    t['font']['color'] = Color.RGB(255,0,0)  # Wenn Akkord nicht greifbar, rot frben
                #messageBox('SPEC',str(spec) + '     ' + str(acc))
                if spec <> 'R' and spec <> 'Z':
                    t['content'] = acc                       # Akkord einfgen
                    t['tag'] = '2086-50'                     # und als Akkord markieren
                    t['y']   = -3.0
                    no.addDrawObj(t)
                    #spec = 'X'
                t['content'] = id                            # BassID einfgen
                t['tag'] = '2086-51'                         # und als ID markieren
                t['font']['color'] = Color.RGB(255,255,255)  # unsichtbar machen
                no.addDrawObj(t)

                #messageBox('inhalt',str(chord))
                if chord <> '-': 
                    t['content'] = chord
                    t['tag'] = tag
                    t['font']['color'] = Color.RGB(0,0,0)            # wieder schwarz
                if chord == '-' and spec <> 'R' and spec <> 'Z':     # falls Akkord nicht vorhanden
                    no.deleteDrawObj(i)                      # lschen
                else:                                        # ansonsten, bersetzten Akkord einfgen
                    ZA_flag = 1                              # und merken
                    t['y']   = 5.0
                    no.replaceDrawObj(i,t)

                if setInstr == 0:
                    instr = instrument.split('/',1)
                    t['font']['height'] = 8                  # Font Gre ndern
                    t['x']      = -18.4
                    t['y']      = -13.4
                    if float(id) <= 10:
                        instrTyp = '4-Reiher'
                    else: instrTyp = '3-Reiher'
                    t['content'] = instrTyp + ' - ' + instr[0]   # Instrumententyp einfgen
                    t['tag'] = '2086-52'                     # und als Instrument markieren
                    no.addDrawObj(t)  
                    t['content'] = instr[1].lstrip()         # Belegung des Instruments einfgen
                    t['y']      = -11
                    t['tag'] = '2086-53'                     # und als Belegung markieren
                    no.addDrawObj(t)
                    #messageBox('T',str(t))
                    no.addDrawObj(gb)                        # Griffbild fr die Bsse einfgen
                    setInstr = 1
    
                i -= 1
    return        

def isMoll(note):                           # prfen ob bei einem transponierbaren Objekt ein Mollakkord                                  
                                            # oder ein verminderter Akkord vorliegt
    a = 0
    #messageBox('Moll',str(note))
    for d in note.drawObjs():
        if d['type'] == 'transposable':
            liste = d['items']
            #messageBox('Liste',str(liste))
            liste.reverse()
            lastElement = liste.pop()
            #messageBox('LastElement',str(lastElement))
            if 'content' in lastElement:                         # Fuchs 1
                ak = lastElement['content']                      # Akkordbezeichnung
                #messageBox('Content1a',str(ak))
                if ak == 'Transponierbare Symbole':
                    lastElement = liste.pop()
                    akkord = lastElement['data']
                    #messageBox('Content1b',str(akkord))
                    ix = akkord.find('plain')
                    ak = akkord[ix:]
                    #messageBox('Content1c',str(ak))             # Fuchs 3, Capella Standard 2 ( C7 Symbol )
                ak1 = ak[0]
                if ak1 in ['c','d','e','f','g','a','h','b']:     # Capella Standard 1  ( gelieferte transp. Sym. )
                    a = 1
                    break
                #messageBox('AK',str(ak))
                if '-' in ak:
                    a = 2                                        # wenn - drin, dann vermindert
                    break
                elif 'im' in ak:
                    a = 2                                        # wenn dim drin, dann vermindert
                    break
                elif 'm' in ak:
                    a = 1                                        # wenn m drin, dann Moll
                    break
                elif '7' in ak:
                    a = 3                                        # wenn 7 drin, dann Septime
                    break
                #messageBox('A',str(a))
                
            elif 'items' in lastElement:
                #messageBox('items',str(lastElement))
                liste.reverse()
                lastElement = liste.pop()
                typ = lastElement['type']
                if typ == 'group':                                # Fuchs 2
                    liste = lastElement['items']
                    ak = liste.pop()                              # m = Moll
                    ac = ak['content']
                    #messageBox('items 1',str(ac))
                    if 'im' in str(ac):
                        a = 2
                    elif '-' in str(ac):
                        a = 2                                     # wenn - drin, dann Vermindert
                        break
                    elif 'm' in str(ac):
                        a = 1                                     # wenn m drin, dann Moll
                        break
                    elif '7' in ak:
                        a = 3                                     # wenn 7 drin, dann Septime
                        break
                else:
                    messageBox(tr('msgA01'),tr('msgA02') + '\n' + str(lastElement))
                
            elif 'data' in lastElement:                           # Fuchs 4 - Septime hochgestellt
                #messageBox('data',str(lastElement))                Capella Standard 1 - Septime hochgestellt
                ak = lastElement['data']
                ix = ak.find('plain')
                ac = ak[ix:]
                #messageBox('fffff',str(ac))
                if 'im' in str(ac):
                    a = 2                                         # wenn dim drin, dann Vermindert
                    break
                elif '-' in str(ac):
                    a = 2                                         # wenn - drin, dann Vermindert
                    break
                elif 'm' in ac:
                    a = 1                                         # wenn m drin, dann Moll
                    break
                elif '7' in ak:
                    a = 3                                         # wenn 7 drin, dann Septime
                    break
            else:                                                    
                #messageBox(msgA01,msgA02 + '\n' + str(lastElement))
                break
            break
    #messageBox('items 1',str(ac) + '      ' + str(a))    
    return a                                                      


def transposeNeu(transposeFrom, transposeTo):

    transposeFrom = int(transposeFrom)
    transposeTo   = int(transposeTo)    
    
    toC = {7:[-1,-1],   # cis
           6:[-4,0],    # fis
           5:[-7,0],    # h
           4:[-3,0],    # e
           3:[-6,0],    # a
           2:[-2,0],    # d
           1:[-5,0],    # g
           0:[0,-1],    # c
           -1:[-3,-1],  # f
           -2:[-6,-1],  # b
           -3:[-2,-1],  # es
           -4:[-5,-1],  # as
           -5:[-1,-1],  # des
           -6:[-4,-1],  # ges
           -7:[-7,0]}   # ces

    fromC = {7:[-7,0],  # cis
             6:[-4,0],  # fis
             5:[-1,-1], # h
            4:[3,0],    # e
            3:[6,0],    # a
            2:[2,0],    # d
            1:[5,0],    # g
            0:[0,-1],   # c
           -1:[3,-1],   # f
           -2:[6,-1],   # b
           -3:[2,-1],   # es
           -4:[5,-1],   # as
           -5:[1,-1],   # des
           -6:[4,-1],   # ges
           -7:[7,0]}    # ces

    for system in activeScore().systems():
        for staff in system.staves(): 
            staff.transpose(toC[transposeFrom])
            staff.transpose(fromC[transposeTo])
            if transposeTo > 5:
                staff.transpose([7,-1])  #  + 1 Oktave
    return

            
def transposeKey(tArt, tList):

    for no in activeScore().noteObjs():
        if no.isChord():
            keyw  = str(no.curKey())
            okeyw = keyw
            transposeFrom = okeyw 
            wo = welcheReihe(tArt,tList,okeyw)
            if wo == 'Z':transposeTo = 0
            elif wo == 'I':transposeTo = 1
            elif wo == 'M':transposeTo = 2
            elif wo == 'A':transposeTo = 3
            break
    transposeNeu(transposeFrom, transposeTo)
    return                                                   

def BassDialog():
    global bassList, Version

    optionsBD = ScriptOptions()
    optBD = optionsBD.get()
    bs = '0'
    t1 = '1'
    t2 = '1'
    t3 = '1'
    t4 = '1'
    if optBD:
        bs = optBD.get('dbs',bs)
        t1 = optBD.get('dt1',t1)
        t2 = optBD.get('dt2',t2)
        t3 = optBD.get('dt3',t3)
        t4 = optBD.get('dt4',t4)

    txt30 = tr('msgA03') + str(bassList['11']['Bass'])
    txt31 = tr('msgA03') + str(bassList['12']['Bass'])
    txt32 = tr('msgA03') + str(bassList['13']['Bass'])
    txt33 = tr('msgA03') + str(bassList['14']['Bass'])
    txt34 = tr('msgA03') + str(bassList['15']['Bass'])
    txt35 = tr('msgA03') + str(bassList['16']['Bass'])
    txt36 = tr('msgA03') + str(bassList['17']['Bass'])
    txt37 = tr('msgA03') + str(bassList['18']['Bass'])
    txt38 = tr('msgA03') + str(bassList['19']['Bass'])
    txt39 = tr('msgA03') + str(bassList['20']['Bass'])
    txt40 = tr('msgA04') + str(bassList['01']['Bass'])
    txt41 = tr('msgA04') + str(bassList['02']['Bass'])
    txt42 = tr('msgA04') + str(bassList['03']['Bass'])
    txt43 = tr('msgA04') + str(bassList['04']['Bass'])
    txt44 = tr('msgA04') + str(bassList['05']['Bass'])
    txt45 = tr('msgA04') + str(bassList['06']['Bass'])
    txt46 = tr('msgA04') + str(bassList['07']['Bass'])
    txt47 = tr('msgA04') + str(bassList['08']['Bass'])
    txt48 = tr('msgA04') + str(bassList['09']['Bass'])
    txt49 = tr('msgA04') + str(bassList['10']['Bass'])
    
    placeholder    = Label('                                            ',width=1)
    lablKey1       = Label(tr('msgA05'),width=6)
    lablKey2       = Label('            ',width=6)
    
    radDefBs       = Radio([txt40,txt41,txt42,txt43,txt44,txt45,txt46,txt47,txt48,txt49,txt30,txt31,txt32,txt33,txt34,txt35,txt36,txt37,txt38,txt39],text=tr('msgA06'),value=int(optBD.get('dbs',str(bs))))
    subboxDefBs    = HBox([radDefBs,placeholder],padding=4)
    box  = VBox([lablKey1,lablKey2,subboxDefBs,placeholder],padding=1)
    dlg  = Dialog('Ziach_A  Version: ' +Version, box)
    if dlg.run():
        id=str(radDefBs.value()+1)
        optBD  = dict(
                      dbs = str(radDefBs.value()),
                      dt1 = str(t1),
                      dt2 = str(t2),
                      dt3 = str(t3),
                      dt4 = str(t4)
                      )
        optionsBD.set(optBD)
        if len(id)== 1:
            id = '0' + id
        return id
    else:
        return False
    
def transDialog1(id):
    global tArt

    optionsBD = ScriptOptions()
    optBD = optionsBD.get()
    bs = '0'
    t1 = '1'
    t2 = '1'
    t3 = '1'
    t4 = '1'
    if optBD:
        bs = optBD.get('dbs',bs)
        t1 = optBD.get('dt1',t1)
        t2 = optBD.get('dt2',t2)
        t3 = optBD.get('dt3',t3)
        t4 = optBD.get('dt4',t4)
        
    placeholder    = Label('                                            ',width=1)
    lablKey1       = Label(tr('msgA07'),width=6)
    lablKey2       = Label('            ',width=6)
    if id < '11':
        radDefKey  = Radio([tr('msgA08'),tr('msgA09'),tr('msgA10'),tr('msgA11')],text=tr('msgA12'),value=int(optBD.get('dt1',str(t1))))
    else:
        radDefKey  = Radio([tr('msgA08'),tr('msgA09'),tr('msgA10')],text=tr('msgA12'),value=int(optBD.get('dt1',str(t1))))
    subboxDefKey   = HBox([radDefKey,placeholder],padding=4)
    box  = VBox([lablKey1,lablKey2,subboxDefKey,placeholder],padding=1)
    dlg  = Dialog('Ziach_A:', box)
    if dlg.run():
        if radDefKey.value() == 0:
            tArt = 'A'
        elif radDefKey.value() == 1:
            tArt = 'M'
        elif radDefKey.value() == 2:
            tArt = 'I'
        elif radDefKey.value() == 3:
            tArt = 'Z'    
        optBD  = dict(
                      dbs = str(bs),
                      dt1 = str(radDefKey.value()),
                      dt2 = str(t2),
                      dt3 = str(t3),
                      dt4 = str(t4)
                      )
        optionsBD.set(optBD)
        return True
    else:
        return False

def transDialog2(id):
    global tArt

    optionsBD = ScriptOptions()
    optBD = optionsBD.get()
    bs = '0'
    t1 = '1'
    t2 = '1'
    t3 = '1'
    t4 = '1'
    if optBD:
        bs = optBD.get('dbs',bs)
        t1 = optBD.get('dt1',t1)
        t2 = optBD.get('dt2',t2)
        t3 = optBD.get('dt3',t3)
        t4 = optBD.get('dt4',t4)
        
    placeholder    = Label('                                            ',width=1)
    lablKey1       = Label(tr('msgA17'),width=6)
    lablKey2       = Label('            ',width=6)
    if id < '11':
        radDefKey  = Radio([tr('msgA13'),tr('msgA14'),tr('msgA15')],text=tr('msgA16'),value=int(optBD.get('dt2',str(t2))))
    else:
        radDefKey  = Radio([tr('msgA13'),tr('msgA14')],text=tr('msgA16'),value=int(optBD.get('dt2',str(t2))))
    subboxDefKey   = HBox([radDefKey,placeholder],padding=4)
    box  = VBox([lablKey1,lablKey2,subboxDefKey,placeholder],padding=1)
    dlg  = Dialog('Ziach_A:', box)
    if dlg.run():
        if radDefKey.value() == 0:
            tArt = 'I'
        elif radDefKey.value() == 1:
            tArt = 'M'
        else: 
            tArt = 'Z'
        optBD  = dict(
                      dbs = str(bs),
                      dt1 = str(t1),
                      dt2 = str(radDefKey.value()),
                      dt3 = str(t3),
                      dt4 = str(t4)
                      )
        optionsBD.set(optBD)
        return True
    else:
        return False

def transDialog3(id):
    global tArt

    optionsBD = ScriptOptions()
    optBD = optionsBD.get()
    bs = '0'
    t1 = '1'
    t2 = '1'
    t3 = '1'
    t4 = '1'
    if optBD:
        bs = optBD.get('dbs',bs)
        t1 = optBD.get('dt1',t1)
        t2 = optBD.get('dt2',t2)
        t3 = optBD.get('dt3',t3)
        t4 = optBD.get('dt4',t4)
        
    placeholder    = Label('                                            ',width=1)
    lablKey1       = Label(tr('msgA17'),width=6)
    lablKey2       = Label('            ',width=6)
    if id < '11':
        radDefKey  = Radio([tr('msgA18'),tr('msgA19')],text=tr('msgA16'),value=int(optBD.get('dt3',str(t3))))
    else:
        radDefKey  = Radio([tr('msgA18'),tr('msgA19')],text=tr('msgA16'),value=int(optBD.get('dt3','0')))
        tArt = 'I'
        return True
    subboxDefKey   = HBox([radDefKey,placeholder],padding=4)
    box  = VBox([lablKey1,lablKey2,subboxDefKey,placeholder],padding=1)
    dlg  = Dialog('Ziach_A:', box)
    if dlg.run():
        if radDefKey.value() == 0:
            tArt = 'I'
        else: 
            tArt = 'Z'
        optBD  = dict(
                      dbs = str(bs),
                      dt1 = str(t1),
                      dt2 = str(t2),
                      dt3 = str(radDefKey.value()),
                      dt4 = str(t4)
                      )
        optionsBD.set(optBD)
        return True
    else:
        return False

def transDialog4(id):
    global tArt

    optionsBD = ScriptOptions()
    optBD = optionsBD.get()
    bs = '0'
    t1 = '1'
    t2 = '1'
    t3 = '1'
    t4 = '1'
    if optBD:
        bs = optBD.get('dbs',bs)
        t1 = optBD.get('dt1',t1)
        t2 = optBD.get('dt2',t2)
        t3 = optBD.get('dt3',t3)
        t4 = optBD.get('dt4',t4)
        
    placeholder    = Label('                                            ',width=1)
    lablKey1       = Label(tr('msgA17'),width=6)
    lablKey2       = Label('            ',width=6)
    if id < '11':
        radDefKey  = Radio([tr('msgA20'),tr('msgA21')],text=tr('msgA16'),value=int(optBD.get('dt4',str(t4))))
    else:
        radDefKey  = Radio([tr('msgA20'),tr('msgA21')],text=tr('msgA16'),value=int(optBD.get('dt4','0')))
        tArt = 'I'
        optBD  = dict(
                      dbs = str(bs),
                      dt1 = str(t1),
                      dt2 = str(t2),
                      dt3 = str(t3),
                      dt4 = str(radDefKey.value())
                      )
        optionsBD.set(optBD)
        return True
    subboxDefKey   = HBox([radDefKey,placeholder],padding=4)
    box  = VBox([lablKey1,lablKey2,subboxDefKey,placeholder],padding=1)
    dlg  = Dialog('Ziach_A:', box)
    if dlg.run():
        if radDefKey.value() == 0:
            tArt = 'I'
        else: 
            tArt = 'Z'
        optBD  = dict(
                      dbs = str(bs),
                      dt1 = str(t1),
                      dt2 = str(t2),
                      dt3 = str(t3),
                      dt4 = str(radDefKey.value())
                      )
        optionsBD.set(optBD)
        return True
    else:
        return False

# Hauptprogramm:

from caplib.capDOM import ScoreChange
import tempfile
from sys import *

global tArt, bassList, ZA_flag, instrument, gb

tList        = []
tArt         = 'T'
ZA_flag      = 0
bug = 0
activeScore().registerUndo("Ziach_A")

meterMerker = 0                                                 #prfen ob Takt eingetragen ist
for sysix in range(activeScore().nSystems()):
    XVoice = activeScore().system(sysix).staff(0).voice(0)                      
    for i in range(XVoice.nNoteObjs()):        
        note = XVoice.noteObj(i)
        if note.subType() == NoteObj.METER:
            meterMerker = 1
            break
if meterMerker == 0:
    messageBox('Ziach_A',str(tr('msgA26')))
    bug = 1
    
for sysix in range(activeScore().nSystems()):                    # Warnung bei leeren Systemen
    XNOs = activeScore().system(sysix).staff(0).voice(0).nNoteObjs()
    if XNOs == 0:
        messageBox('Ziach_A',str(tr('msgA27')) + str(sysix+1))
        bug = 1
        break

if bug == 0:    
    bassList     = {}
    dir, pyFile = os.path.split(sys.argv[0])
    defDatei = os.path.join(dir, 'Ziach_DEF.py')
    datei        = file(defDatei,'r')
    #datei        = file(getProgramDir()+'\scripts'+'\Ziach_DEF.txt','r')
    lines        = datei.readlines()
    daten        = [line for line in lines if line[0:2] != '#-']  # Kommentarzeilen raus
    for i in range(len(daten)):                                  # Bass-Systeme einlesen

        if daten[i][0:7] == '#Reihen':                           # Instrumententyp extrahieren ( 3 oder 4-Reiher )
            instrument = daten[i][16]

        if daten[i][0:12] == '#Bass-System':                     # Bass-System extrahieren
            bass = daten[i][16:63]

        if daten[i][0:14] == '#Bass-Belegung':                   # Bass-Belegung extrahieren
            bBel = daten[i][16:63]
        
        if daten[i][0:3] == '#ID':                               # ID extrahieren
            bassID = daten[i][16:18]
        
        if daten[i][0:3] == '#F ':                               # Bass Belegung fr die F-Reihe ( C-Dur )
            F1G = daten[i][17:19].strip()
            F1R = daten[i][21:23].strip()
            F2G = daten[i][25:27].strip()
            F2R = daten[i][29:31].strip()
            F3G = daten[i][33:35].strip()
            F3R = daten[i][37:39].strip()
            F4G = daten[i][41:43].strip()
            F4R = daten[i][45:47].strip()
            F5G = daten[i][49:51].strip()
            F5R = daten[i][53:55].strip()
            F6G = daten[i][57:59].strip()
            F6R = daten[i][61:63].strip()
            F7G = daten[i][65:67].strip()
            F7R = daten[i][69:71].strip()
            F8G = daten[i][73:75].strip()
            F8R = daten[i][77:79].strip()
            F9G = daten[i][81:83].strip()
            F9R = daten[i][85:87].strip()
            FAG = daten[i][89:91].strip()
            FAR = daten[i][93:95].strip()
            FBG = daten[i][97:99].strip()
            FBR = daten[i][101:103].strip()
        
        if daten[i][0:3] == '#A ':                                # Bass Belegung fr die A-Reihe ( G-Dur )
            A1G = daten[i][17:19].strip()
            A1R = daten[i][21:23].strip()
            A2G = daten[i][25:27].strip()
            A2R = daten[i][29:31].strip()
            A3G = daten[i][33:35].strip()
            A3R = daten[i][37:39].strip()
            A4G = daten[i][41:43].strip()
            A4R = daten[i][45:47].strip()
            A5G = daten[i][49:51].strip()
            A5R = daten[i][53:55].strip()
            A6G = daten[i][57:59].strip()
            A6R = daten[i][61:63].strip()
            A7G = daten[i][65:67].strip()
            A7R = daten[i][69:71].strip()
            A8G = daten[i][73:75].strip()
            A8R = daten[i][77:79].strip()
            A9G = daten[i][81:83].strip()
            A9R = daten[i][85:87].strip()
            AAG = daten[i][89:91].strip()
            AAR = daten[i][93:95].strip()
            ABG = daten[i][97:99].strip()
            ABR = daten[i][101:103].strip()

        if daten[i][0:3] == '#B ':                                # Bass Belegung fr die B-Reihe ( D-Dur )
            B1G = daten[i][17:19].strip()
            B1R = daten[i][21:23].strip()
            B2G = daten[i][25:27].strip()
            B2R = daten[i][29:31].strip()
            B3G = daten[i][33:35].strip()
            B3R = daten[i][37:39].strip()
            B4G = daten[i][41:43].strip()
            B4R = daten[i][45:47].strip()
            B5G = daten[i][49:51].strip()
            B5R = daten[i][53:55].strip()
            B6G = daten[i][57:59].strip()
            B6R = daten[i][61:63].strip()
            B7G = daten[i][65:67].strip()
            B7R = daten[i][69:71].strip()
            B8G = daten[i][73:75].strip()
            B8R = daten[i][77:79].strip()
            B9G = daten[i][81:83].strip()
            B9R = daten[i][85:87].strip()
            BAG = daten[i][89:91].strip()
            BAR = daten[i][93:95].strip()
            BBG = daten[i][97:99].strip()
            BBR = daten[i][101:103].strip()
        
        if daten[i][0:3] == '#C ':                                # Bass Belegung fr die C-Reihe ( A-Dur )
            C1G = daten[i][17:19].strip()
            C1R = daten[i][21:23].strip()
            C2G = daten[i][25:27].strip()
            C2R = daten[i][29:31].strip()
            C3G = daten[i][33:35].strip()
            C3R = daten[i][37:39].strip()
            C4G = daten[i][41:43].strip()
            C4R = daten[i][45:47].strip()
            C5G = daten[i][49:51].strip()
            C5R = daten[i][53:55].strip()
            C6G = daten[i][57:59].strip()
            C6R = daten[i][61:63].strip()
            C7G = daten[i][65:67].strip()
            C7R = daten[i][69:71].strip()
            C8G = daten[i][73:75].strip()
            C8R = daten[i][77:79].strip()
            C9G = daten[i][81:83].strip()
            C9R = daten[i][85:87].strip()
            CAG = daten[i][89:91].strip()
            CAR = daten[i][93:95].strip()
            CBG = daten[i][97:99].strip()
            CBR = daten[i][101:103].strip()

        if daten[i][0:4] == '#GR1':                               # Griffbild Reihe 1
            G1A = daten[i][17:19]
            G1B = daten[i][22:24]
            G1C = daten[i][27:29]
            G1D = daten[i][32:34]
            G1E = daten[i][37:39]
            G1F = daten[i][42:44]
            G1G = daten[i][47:49]
            G1H = daten[i][52:54]
            G1I = daten[i][57:59]
            G1J = daten[i][62:64]
            G1K = daten[i][67:69]
            G1L = daten[i][72:74]
        
        if daten[i][0:4] == '#GR2':                               # Griffbild Reihe 2
            G2A = daten[i][19:21]
            G2B = daten[i][24:26]
            G2C = daten[i][29:31]
            G2D = daten[i][34:36]
            G2E = daten[i][39:41]
            G2F = daten[i][44:46]
            G2G = daten[i][49:51]
            G2H = daten[i][54:56]
            G2I = daten[i][59:61]
            G2J = daten[i][64:66]
            G2K = daten[i][69:71]               
        
        if daten[i][0:4] == '#END':                              # Wenn das Ende der Tabelle fr ein Basssystem erreicht ist

            bass = bass.rstrip()
            bBel = bBel.rstrip()
            if len(bass) == 0: msgA25i = ' '
            else: msgA25i = ' / ' + tr('msgA25') + ' : '
        
            if instrument == '3':                                
                entry = {bassID:{'Instrument':instrument,'Bass':bass + msgA25i + bBel,
                                 'C':{'gG':C1G,'rG':C1R,'gAm':C2G,'rAm':C2R,'gBm':C3G,'rBm':C3R,'gHm':C3G,'rHm':C3R,
                                      'gC':C4G,'rC':C4R,'gD':C5G,'rD':C5R,'gD7':C6G,'rD7':C6R,'gEm':C7G,'rEm':C7R,
                                      'gF#-':C8G,'rF#-':C8R,'gA7':C9G,'rA7':C9R,'gDD':CAG,'rDD':CAR,'gB7':CBG,'rB7':CBR},
                                 'B':{'gD':B1G,'rD':B1R,'gEm':B2G,'rEm':B2R,'gF#m':B3G,'rF#m':B3R,'gG':B4G,'rG':B4R,
                                      'gA':B5G,'rA':B5R,'gA7':B6G,'rA7':B6R,'gBm':B7G,'rBm':B7R,'gHm':B7G,'rHm':B7R,
                                      'gC#-':B8G,'rC#-':B8R,'gE7':B9G,'rE7':B9R,'gAD':BAG,'rAD':BAR,'gF#7':BBG,'rF#7':BBR},     
                                 'A':{'gA':A1G,'rA':A1R,'gBm':A2G,'rBm':A2R,'gHm':A2G,'rHm':A2R,
                                      'gC#m':A3G,'rC#m':A3R,'gD':A4G,'rD':A4R,'gE':A5G,'rE':A5R,'gE7':A6G,'rE7':A6R,
                                      'gF#m':A7G,'rF#m':A7R,'gG#-':A8G,'rG#-':A8R,'gH7':A9G,'rH7':A9R,
                                      'gB7':A9G,'rB7':A9R,'gED':AAG,'rED':AAR,'gC#7':ABG,'rC#7':ABR},
                                 'G1':{'g1A':G1A,'g1B':G1B,'g1C':G1C,'g1D':G1D,'g1E':G1E,'g1F':G1F,'g1G':G1G,'g1H':G1H,
                                       'g1I':G1I,'g1J':G1J,'g1K':G1K,'g1L':G1L},
                                 'G2':{'g2A':G2A,'g2B':G2B,'g2C':G2C,'g2D':G2D,'g2E':G2E,'g2F':G2F,'g2G':G2G,'g2H':G2H,
                                       'g2I':G2I,'g2J':G2J,'g2K':G2K}
                         }}
                bassList.update(entry)                           # dann in Directory schreiben
            if instrument == '4':
                entry = {bassID:{'Instrument':instrument,'Bass':bass + msgA25i + bBel,
                                 'F':{'gC':F1G,'rC':F1R,'gDm':F2G,'rDm':F2R,'gEm':F3G,'rEm':F3R,'gF':F4G,'rF':F4R,
                                      'gG':F5G,'rG':F5R,'gG7':F6G,'rG7':F6R,'gAm':F7G,'rAm':F7R,'gB-':F8G,'rB-':F8R,
                                      'gH-':F8G,'rH-':F8R,'gD7':F9G,'rD7':F9R,'gGD':FAG,'rGD':FAR,'gE7':FBG,'rE7':FBR},
                                 'C':{'gG':C1G,'rG':C1R,'gAm':C2G,'rAm':C2R,'gBm':C3G,'rBm':C3R,'gHm':C3G,'rHm':C3R,
                                      'gC':C4G,'rC':C4R,'gD':C5G,'rD':C5R,'gD7':C6G,'rD7':C6R,'gEm':C7G,'rEm':C7R,
                                      'gF#-':C8G,'rF#-':C8R,'gA7':C9G,'rA7':C9R,'gDD':CAG,'rDD':CAR,'gB7':CBG,'rB7':CBR},
                                 'B':{'gD':B1G,'rD':B1R,'gEm':B2G,'rEm':B2R,'gF#m':B3G,'rF#m':B3R,'gG':B4G,'rG':B4R,
                                      'gA':B5G,'rA':B5R,'gA7':B6G,'rA7':B6R,'gBm':B7G,'rBm':B7R,'gHm':B7G,'rHm':B7R,
                                      'gC#-':B8G,'rC#-':B8R,'gE7':B9G,'rE7':B9R,'gAD':BAG,'rAD':BAR,'gF#7':BBG,'rF#7':BBR},     
                                 'A':{'gA':A1G,'rA':A1R,'gBm':A2G,'rBm':A2R,'gHm':A2G,'rHm':A2R,
                                      'gC#m':A3G,'rC#m':A3R,'gD':A4G,'rD':A4R,'gE':A5G,'rE':A5R,'gE7':A6G,'rE7':A6R,
                                      'gF#m':A7G,'rF#m':A7R,'gG#-':A8G,'rG#-':A8R,'gH7':A9G,'rH7':A9R,
                                      'gB7':A9G,'rB7':A9R,'gED':AAG,'rED':AAR,'gC#7':ABG,'rC#7':ABR},
                                 'G1':{'g1A':G1A,'g1B':G1B,'g1C':G1C,'g1D':G1D,'g1E':G1E,'g1F':G1F,'g1G':G1G,'g1H':G1H,
                                       'g1I':G1I,'g1J':G1J,'g1K':G1K,'g1L':G1L},
                                 'G2':{'g2A':G2A,'g2B':G2B,'g2C':G2C,'g2D':G2D,'g2E':G2E,'g2F':G2F,'g2G':G2G,'g2H':G2H,
                                       'g2I':G2I,'g2J':G2J,'g2K':G2K}
                         }}
                bassList.update(entry)
                # Abfrage : xx = bassList['02']['A']['gHm']

    #messageBox('Basslist',str(len(bassList)))
    #xx = bassList['11']['A']['gHm']
    #xx = bassList['11']['Bass']
    #messageBox('Basslist',str(xx))
            
    id=BassDialog()                                       # Bass-System auswhlen
    instrument = bassList[id]['Bass']
    #messageBox('ID',str(id) + '\n' + str(instrument))

    #Bassbelegung laden und in Dictionary einfgen

    r1a = bassList[id]['G1']['g1A']
    r1b = bassList[id]['G1']['g1B']
    r1c = bassList[id]['G1']['g1C']
    r1d = bassList[id]['G1']['g1D']
    r1e = bassList[id]['G1']['g1E']
    r1f = bassList[id]['G1']['g1F']
    r1g = bassList[id]['G1']['g1G']
    r1h = bassList[id]['G1']['g1H']
    r1i = bassList[id]['G1']['g1I']
    r1j = bassList[id]['G1']['g1J']
    r1k = bassList[id]['G1']['g1K']
    r1l = bassList[id]['G1']['g1L']
    r2a = bassList[id]['G2']['g2A']
    r2b = bassList[id]['G2']['g2B']
    r2c = bassList[id]['G2']['g2C']
    r2d = bassList[id]['G2']['g2D']
    r2e = bassList[id]['G2']['g2E']
    r2f = bassList[id]['G2']['g2F']
    r2g = bassList[id]['G2']['g2G']
    r2h = bassList[id]['G2']['g2H']
    r2i = bassList[id]['G2']['g2I']
    r2j = bassList[id]['G2']['g2J']
    r2k = bassList[id]['G2']['g2K']

    basscont1 = r1a + ' ' + r1b + ' ' + r1c + ' ' + r1d + ' ' + r1e + ' ' + r1f + ' ' + r1g + ' ' + r1h + ' ' + r1i + ' ' + r1j + ' ' + r1k + ' ' + r1l
    basscont2 = '\r\n ' + r2a + ' ' + r2b + ' ' + r2c + ' ' + r2d + ' ' + r2e + ' ' + r2f + ' ' + r2g + ' ' + r2h + ' ' + r2i + ' ' + r2j + ' ' + r2k
    basscont  = basscont1 + basscont2

    gb = {'items':[{'y':-8.3,'x':-17,'font':{'pitchAndFamily':49,'height':5.0,'weight':700,'face':'CourierNew'},
                    'type':'text','content':basscont},
                   {'y2':-5.7,'lineWidth':0.2,'behindNotes':True,'x2':8,'y1':-10,'x1':-18.3,'type':'rectangle'}],'type':'group'}
    if id:
        for no in activeScore().noteObjs():               # Tonarten festhalten
            if no.isChord():
                tonart = no.curKey()
                if tonart not in tList:
                    tList.append(tonart)
        tList.sort()

        flag  = 'OK'
        delta = tList[len(tList)-1] - tList[0]
        #messageBox('LEN',str(len(tList)) + '   ' + str(int(id)) + '   ' + str(tList))
        if len(tList) > 4:                               # mehr als 4 Tonarten
            flag = 'exit'
        elif len(tList) > 3 and int(id) >= 10:           # 3-Reiher ausgewhlt aber mehr als 3 Tonarten
            #messageBox('Raus1','raus1')
            flag = 'exit'
        elif tList[len(tList)-1] - tList[0] > 3:         # mehr als 3 Tonarten auseinander
            #messageBox('Raus2','raus2')
            flag = 'exit'
        elif tList[len(tList)-1] - tList[0] > 2 and int(id) >= 10:   # mehr als 2 Tonarten auseinander und 3-Reiher
            #messageBox('Raus3','raus3')
            flag = 'exit'
       
        if len(tList) == 1 and flag == 'OK':             # nur eine Tonart
            if transDialog1(id):                         # gezielt transponieren
                transposeAcc(id)                         # Akkorde transponieren
                transposeKey(tArt, tList)                # Tonart normalisieren        
            
        elif len(tList) == 2 and flag == 'OK' and delta == 1: # 2 Tonarten nebeneinander
            if transDialog2(id):                         # gezielt transponieren
                transposeAcc(id)                         # Akkorde transponieren
                transposeKey(tArt, tList)                # Tonart normalisieren
            
        elif len(tList) == 2 and flag == 'OK' and delta == 2: # 2 Tonarten eine Lcke von 1
            if transDialog3(id):                         # gezielt transponieren
                transposeAcc(id)                         # Akkorde transponieren
                transposeKey(tArt, tList)                # Tonart normalisieren
        
        elif len(tList) == 3 and flag == 'OK' and delta == 2: # 3 Tonarten eine Lcke von 1
            if transDialog4(id):                         # gezielt transponieren
                transposeAcc(id)                         # Akkorde transponieren
                transposeKey(tArt, tList)                # Tonart normalisieren
        else:
            if flag == 'OK':                             # 4 Tonarten,3 Tonarten mit einer Lcke, 2 Tonarten mit 2 Lcken
                tArt = 'T'                               # Alles Transponieren
                transposeAcc(id)                         # Akkorde transponieren
                transposeKey(tArt, tList)                # Tonart normalisieren
        
        if flag == 'exit':
            messageBox('Ziach_A:',tr('msgA23') + '\n\n' + tr('msgA22'))
        if ZA_flag == 0:
            messageBox('Ziach_A:',tr('msgA23') + '\n\n' + tr('msgA24'))
            
