# -*- coding: ISO-8859-1 -*-
""" capellaScript -- Copyright (c) 2004-2012 Peter Becker
>>> Ziach_B: Tabulaturschrift fr Steirische Harmonika
    Umsetzen von Noten in die Tabulaturschrift fr Steirische Harmonika.
    -> Schritt 2 von 3||
    Translation of dotted notes into Griffschrift for Steirische.||
    -> Step 2 of 3||
    
    Achtung ( Attention ): |
    - Bass-Definitionen in Ziach_DEF.py|
    - Language in Ziach_tr.py||
    
    Bei Problemen bitte eine Mail an |
    (In case of problems, please email ):|peter_becker@freenet.de
<<<

History:  16.07.04 - Version 1.0            
          29.11.04 - Version 2.0 Split into 3 Modules 
          27.12.05 - Version 3.0 National Language Support
          08.05.09 - Version 4.0, .DEF und .MSG als Python Datei
          09.05.09 - Sprachauswahl hinzugefgt
          20.05.09 - Fehlerhafte Nachricht, nicht mit A vorbereitet, wenn erste Note Pause mit Akkord
          20.05.09 - Einrcken am Zeilenanfang unterbunden
          08.07.09 - KopfOffset fr B7 eingefgt
          25.07.09 - Ausnahmelisten abwhlbar gemacht, Menu heu aufgeteilt
          03.12.09 - falls am Ende der Zeile eine Note oder Pause steht. festen Taktstrich einsteuern
                     um Fehler bei der Platzhaltergenerierung zu vermeiden.
          05.05.10 - Abbruch in Ausnahmeliste korrigiert, wenn Tonumfang berschritten wurde
          14.08.10 - alternative Kopfgre whlbar gemacht
          18.10.10 - Versionsanzeige eingefgt 4.1.1
          11.11.10 - horizontale Position bei Kreuzen als Vorzeichen abhngig von Kopfgre 4.1.2
          17.03.11 - Bindebogen automatisch anpassen 4.1.3
          18.11.11 - V4.1.4 wegen Ziach_A
          10.03.12 - V4.1.5 offener Takt am Ende durch Transposition in Ziach_A
          08.05.12 - V4.1.6 wegen Ziach_C
          07.07.12 - V4.1.8 wegen Ziach_C
          08.07.12 - V4.1.9 wegen Ziach_C
          09.07.12 - V4.1.10 wegen Ziach_C
          10.07.12 - V4.1.11 wegen Ziach_C
          03.08.12 - V4.1.12 krzere Druckmarkierung
          09.08.12 - V4.1.13 wegen Ziach_C
          04.02.13 - V4.1.14 fehlerhafte bersetzung wenn Vorzeichenunterdrckung an aber kein Vorzeichen gesetzt ist.
          21.09.14 - V4.1.15 falsche Drucklist Abfrage
          26.03.15 - V4.2.0  Umstellung auf Capella Multilanguage Support
          31.07.15 - V4.2.1  Wegen Ziach_A
"""
# TAG Liste
# 2086-31 Druck - innen        Reihe C - G-Dur
# 2086-32 Druck - mitte        Reihe B - D-Dur
# 2086-33 Druck - aussen       Reihe A - A-Dur
# 2086-34 Druck - ganz innen   Reihe F - C-Dur
# 2086-41 Zug   - innen        Reihe C - G-Dur
# 2086-42 Zug   - mitte        Reihe B - D-Dur
# 2086-43 Zug   - aussen       Reihe A - A-Dur
# 2086-44 Zug   - ganz innen   Reihe F - C-Dur 
# 2086-50 Akkordbezeichnung
# 2086-51 Bass ID
# 2086-52 Instrumententyp
# 2086-53 Bassbelegung

import xml.dom, tempfile, math
from caplib.capDOM import ScoreChange
from xml.dom.minidom import NodeList, Node, Element

version = '4.2.1 - 31.7.2015'

german = ("de", {
    "msgB01"   : 'Partitur wurde nicht mit "Die_Ziach_A" vorbereitet',
    "msgB02"   : 'anzeigen', 
    "msgB03"   : 'nicht anzeigen',
    "msgB04"   : 'Notenzeile anzeigen', 
    "msgB05"   : 'unterdrcken',
    "msgB06"   : 'rot darstellen',
    "msgB07"   : 'nicht spielbare Noten',
    "msgB08"   : 'klassisch',
    "msgB09"   : 'alternativ',
    "msgB10"   : 'Kopfform',
    "msgB11"   : 'Viertelnoten      ',
    "msgB12"   : 'Achtelnoten      ',
    "msgB13"   : 'Platzhalter fr Begleitung',
    "msgB14"   : 'auf Druck spielen',
    "msgB15"   : 'auf Zug spielen',
    "msgB16"   : 'Auftakt ohne Akkord',
    "msgB17"   : 'Darstellung',
    "msgB18"   : '2 Oktaven nach oben',
    "msgB19"   : '1 Oktav nach oben',
    "msgB20"   : 'normal',
    "msgB21"   : '1 Oktav nach unten',
    "msgB22"   : '2 Oktaven nach unten',
    "msgB23"   : 'ganz innen',
    "msgB24"   : 'innen',
    "msgB25"   : 'mitte',
    "msgB26"   : 'aussen',
    "msgB27"   : 'Noten oktavieren fr die Reihe :',
    "msgB28"   : 'ber erstem System           ',
    "msgB29"   : 'zwischen den Systemen    ',
    "msgB30"   : 'Systemabstnde',
    "msgB31"   : 'Abstand nach oben   ',
    "msgB32"   : 'Abstand nach unten  ',
    "msgB33"   : 'Griffschrift',
    "msgB34"   : 'Abstand von der Mittellinie  ',
    "msgB35"   : 'Strophenabstand                ',
    "msgB36"   : 'Liedtext',
    "msgB37"   : 'Notenzeile',
    "msgB38"   : 'Schriftgre               ',
    "msgB39"   : 'Abstnde',
    "msgB40"   : 'bersetzungsoptionen',
    "msgB41"   : 'Optionen',
    "msgB42"   : 'Ausnahmeliste Zug benutzen',
    "msgB43"   : 'Ausnahmeliste Druck benutzen',
    "msgB44"   : 'Kopfgre bei Alternativdarstellung  '
    })

try:
    from Ziach_tr import translations
    translations.append(german)
    setLanguages(translations)
except:
    #messageBox('Stop','stop')
    def tr(s):
        return german[1].get(s, "???")

#-------------------------------------------------------------------

doc        = [] # parentNode von score
impBarline = 0
summe      = 0
notenWert  = dict(
                  W16 = dict(wert=0.25  , punkt=0.125  ),
                  W8  = dict(wert=0.5   , punkt=0.25   ),
                  W4  = dict(wert=1.0   , punkt=0.5    ),
                  W2  = dict(wert=2.0   , punkt=1.0    ),
                  W1  = dict(wert=4.0   , punkt=2.0    )
                 )

# Dictionary Eintrge  xxyz : xx=Ton, y=0 kein Vorzeichen, y=1 ein Kreuz, y=2 ein b, z=1 Alternative

# GanzInnen Druck - C 4-Reiher
giDruckList1    = dict(
                  C500 = dict(wert='A4' , kreuz='1' ),
                  B410 = dict(wert='A4' , kreuz='1' ),           # enharmonische Verwechslung fr C500
                  E500 = dict(wert='C5' , kreuz='1' ),
                  F520 = dict(wert='C5' , kreuz='1' ),           # enharmonische Verwechslung fr E500
                  G500 = dict(wert='E5' , kreuz='1' ),
                  C600 = dict(wert='G5' , kreuz='1' ),
                  B510 = dict(wert='G5' , kreuz='1' ),           # enharmonische Verwechslung fr C600
                  E600 = dict(wert='B5' , kreuz='1' ),
                  F620 = dict(wert='B5' , kreuz='1' ),           # enharmonische Verwechslung fr E600
                  G600 = dict(wert='D6' , kreuz='1' ),
                  C700 = dict(wert='F6' , kreuz='1' ),
                  B610 = dict(wert='F6' , kreuz='1' ),           # enharmonische Verwechslung fr C700
                  E700 = dict(wert='A6' , kreuz='1' ),
                  F720 = dict(wert='A6' , kreuz='1' ),           # enharmonische Verwechslung fr E600
                  G700 = dict(wert='C7' , kreuz='1' ),
                  C800 = dict(wert='E7' , kreuz='1' ) 
                  )
# Innen Druck - G 3-Reiher
innenDruckList  = dict(
                  G400 = dict(wert='G4' , kreuz='1' ),
                  B400 = dict(wert='B4' , kreuz='1' ),
                  C520 = dict(wert='B4' , kreuz='1' ),           # enharmonische Verwechslung fr B400
                  D500 = dict(wert='D5' , kreuz='1' ),
                  G500 = dict(wert='F5' , kreuz='1' ),
                  B500 = dict(wert='A5' , kreuz='1' ),
                  C620 = dict(wert='A4' , kreuz='1' ),           # enharmonische Verwechslung fr B500
                  D600 = dict(wert='C6' , kreuz='1' ),
                  G600 = dict(wert='E6' , kreuz='1' ),
                  B600 = dict(wert='G6' , kreuz='1' ),
                  C720 = dict(wert='G6' , kreuz='1' ),           # enharmonische Verwechslung fr B600
                  D700 = dict(wert='B6' , kreuz='1' ),
                  G700 = dict(wert='D7' , kreuz='1' ) 
                  )
# Innen Druck - G 4-Reiher
innenDruckList1 = dict(
                  G400 = dict(wert='G4' , kreuz='1' ),
                  B400 = dict(wert='B4' , kreuz='1' ),
                  C520 = dict(wert='B4' , kreuz='1' ),           # enharmonische Verwechslung fr B400
                  D500 = dict(wert='D5' , kreuz='1' ),
                  G500 = dict(wert='F5' , kreuz='1' ),
                  B500 = dict(wert='A5' , kreuz='1' ),
                  C620 = dict(wert='A5' , kreuz='1' ),           # enharmonische Verwechslung fr B500
                  D600 = dict(wert='C6' , kreuz='1' ),
                  G600 = dict(wert='E6' , kreuz='1' ),
                  B600 = dict(wert='G6' , kreuz='1' ),
                  C720 = dict(wert='G6' , kreuz='1' ),           # enharmonische Verwechslung fr B600
                  D700 = dict(wert='B6' , kreuz='1' ),
                  G700 = dict(wert='D7' , kreuz='1' ),
                  B700 = dict(wert='F7' , kreuz='1' ),
                  C820 = dict(wert='F7' , kreuz='1' )            # enharmonische Verwechslung fr B700
                  )
# Mitte Druck - D 3-Reiher
mitteDruckList  = dict(
                  D400 = dict(wert='F4' , kreuz='0' ),
                  F410 = dict(wert='A4' , kreuz='0' ),
                  G420 = dict(wert='A4' , kreuz='0' ),           # enharmonische Verwechslung fr F410
                  A400 = dict(wert='C5' , kreuz='0' ),
                  D500 = dict(wert='E5' , kreuz='0' ),
                  F510 = dict(wert='G5' , kreuz='0' ),
                  G520 = dict(wert='G5' , kreuz='0' ),           # enharmonische Verwechslung fr F510
                  A500 = dict(wert='B5' , kreuz='0' ),
                  D600 = dict(wert='D6' , kreuz='0' ),
                  F610 = dict(wert='F6' , kreuz='0' ),
                  G620 = dict(wert='F6' , kreuz='0' ),           # enharmonische Verwechslung fr F610
                  A600 = dict(wert='A6' , kreuz='0' ),
                  D700 = dict(wert='C7' , kreuz='0' ),
                  F710 = dict(wert='E7' , kreuz='0' ),
                  G720 = dict(wert='E7' , kreuz='0' )            # enharmonische Verwechslung fr F710
                  )
# Mitte Druck - D 4-Reiher
mitteDruckList1 = dict(
                  D400 = dict(wert='F4' , kreuz='0' ),
                  F410 = dict(wert='A4' , kreuz='0' ),
                  G420 = dict(wert='A4' , kreuz='0' ),           # enharmonische Verwechslung fr F410
                  A400 = dict(wert='C5' , kreuz='0' ),
                  D500 = dict(wert='E5' , kreuz='0' ),
                  F510 = dict(wert='G5' , kreuz='0' ),
                  G520 = dict(wert='G5' , kreuz='0' ),           # enharmonische Verwechslung fr F510
                  A500 = dict(wert='B5' , kreuz='0' ),
                  D600 = dict(wert='D6' , kreuz='0' ),
                  F610 = dict(wert='F6' , kreuz='0' ),
                  G620 = dict(wert='F6' , kreuz='0' ),           # enharmonische Verwechslung fr F610
                  A600 = dict(wert='A6' , kreuz='0' ),
                  D700 = dict(wert='C7' , kreuz='0' ),
                  F710 = dict(wert='E7' , kreuz='0' ),
                  G720 = dict(wert='E7' , kreuz='0' ),           # enharmonische Verwechslung fr F710
                  A700 = dict(wert='G7' , kreuz='0' )
                  )
# Aussen Druck - A 3 Reiher
aussenDruckList = dict(
                  A300 = dict(wert='E4' , kreuz='0' ),
                  C410 = dict(wert='G4' , kreuz='0' ),
                  D420 = dict(wert='G4' , kreuz='0' ),           # enharmonische Verwechslung fr C410
                  E400 = dict(wert='B4' , kreuz='0' ),
                  F420 = dict(wert='B4' , kreuz='0' ),           # enharmonische Verwechslung fr E400
                  A400 = dict(wert='D5' , kreuz='0' ),
                  C510 = dict(wert='F5' , kreuz='0' ),
                  D520 = dict(wert='F5' , kreuz='0' ),           # enharmonische Verwechslung fr C510
                  E500 = dict(wert='A5' , kreuz='0' ),
                  F520 = dict(wert='A5' , kreuz='0' ),           # enharmonische Verwechslung fr E500
                  A500 = dict(wert='C6' , kreuz='0' ),
                  C610 = dict(wert='E6' , kreuz='0' ),
                  D620 = dict(wert='E6' , kreuz='0' ),           # enharmonische Verwechslung fr C610
                  E600 = dict(wert='G6' , kreuz='0' ),
                  F620 = dict(wert='G6' , kreuz='0' ),           # enharmonische Verwechslung fr E600
                  A600 = dict(wert='B6' , kreuz='0' ),
                  C710 = dict(wert='D7' , kreuz='0' ),
                  D720 = dict(wert='D7' , kreuz='0' ),           # enharmonische Verwechslung fr C710
                  E700 = dict(wert='F7' , kreuz='0' ),
                  F720 = dict(wert='F7' , kreuz='0' )            # enharmonische Verwechslung fr E700
                  )
# Aussen Druck - A 4-Reiher
aussenDruckList1= dict(
                  A300 = dict(wert='E4' , kreuz='0' ),
                  C410 = dict(wert='G4' , kreuz='0' ),
                  D420 = dict(wert='G4' , kreuz='0' ),           # enharmonische Verwechslung fr C410
                  E400 = dict(wert='B4' , kreuz='0' ),
                  F420 = dict(wert='B4' , kreuz='0' ),           # enharmonische Verwechslung fr E400
                  A400 = dict(wert='D5' , kreuz='0' ),
                  C510 = dict(wert='F5' , kreuz='0' ),
                  D520 = dict(wert='F5' , kreuz='0' ),           # enharmonische Verwechslung fr C510
                  E500 = dict(wert='A5' , kreuz='0' ),
                  F520 = dict(wert='A5' , kreuz='0' ),           # enharmonische Verwechslung fr E500
                  A500 = dict(wert='C6' , kreuz='0' ),
                  C610 = dict(wert='E6' , kreuz='0' ),
                  D620 = dict(wert='E6' , kreuz='0' ),           # enharmonische Verwechslung fr C610
                  E600 = dict(wert='G6' , kreuz='0' ),
                  F620 = dict(wert='G6' , kreuz='0' ),           # enharmonische Verwechslung fr E600
                  A600 = dict(wert='B6' , kreuz='0' ),
                  C710 = dict(wert='D7' , kreuz='0' ),
                  D720 = dict(wert='D7' , kreuz='0' ),           # enharmonische Verwechslung fr C710
                  E700 = dict(wert='F7' , kreuz='0' ),
                  F720 = dict(wert='F7' , kreuz='0' ),           # enharmonische Verwechslung fr E700
                  A700 = dict(wert='A7' , kreuz='0' )
                  )
# GanzInnen Zug - G7 4-Reiher
giZugList1      = dict(
                  F500 = dict(wert='A4' , kreuz='1' ),
                  E510 = dict(wert='A4' , kreuz='1' ),              # enharmonische Verwechslung fr F500
                  G500 = dict(wert='C5' , kreuz='1' ),
                  B500 = dict(wert='E5' , kreuz='1' ),
                  C620 = dict(wert='E5' , kreuz='1' ),              # enharmonische Verwechslung fr B500
                  D600 = dict(wert='G5' , kreuz='1' ),
                  F600 = dict(wert='B5' , kreuz='1' ),
                  E610 = dict(wert='B5' , kreuz='1' ),              # enharmonische Verwechslung fr F600
                  G600 = dict(wert='D6' , kreuz='1' ),
                  B600 = dict(wert='F6' , kreuz='1' ),
                  C720 = dict(wert='F6' , kreuz='1' ),              # enharmonische Verwechslung fr B600
                  D700 = dict(wert='A6' , kreuz='1' ),
                  F700 = dict(wert='C7' , kreuz='1' ),
                  E710 = dict(wert='C7' , kreuz='1' ),              # enharmonische Verwechslung fr F700
                  A700 = dict(wert='E7' , kreuz='1' ) 
                  )
# Innen Zug - D7  3-Reiher
innenZugList  =   dict(
                  C500 = dict(wert='G4' , kreuz='1' ),
                  B410 = dict(wert='G4' , kreuz='1' ),           # enharmonische Verwechslung fr C500
                  D500 = dict(wert='B4' , kreuz='1' ),
                  F510 = dict(wert='D5' , kreuz='1' ),
                  G520 = dict(wert='D5' , kreuz='1' ),           # enharmonische Verwechslung fr F510
                  A500 = dict(wert='F5' , kreuz='1' ),
                  C600 = dict(wert='A5' , kreuz='1' ),
                  B510 = dict(wert='A5' , kreuz='1' ),           # enharmonische Verwechslung fr C600
                  D600 = dict(wert='C6' , kreuz='1' ),
                  F610 = dict(wert='E6' , kreuz='1' ),
                  G620 = dict(wert='E6' , kreuz='1' ),           # enharmonische Verwechslung fr F610
                  A600 = dict(wert='G6' , kreuz='1' ),
                  C700 = dict(wert='B6' , kreuz='1' ),
                  B610 = dict(wert='B6' , kreuz='1' ),           # enharmonische Verwechslung fr C700
                  E700 = dict(wert='D7' , kreuz='1' ) 
                  )
# Innen Zug - D7  4-Reiher
innenZugList1  =  dict(
                  C500 = dict(wert='G4' , kreuz='1' ),
                  B410 = dict(wert='G4' , kreuz='1' ),           # enharmonische Verwechslung fr C500
                  D500 = dict(wert='B4' , kreuz='1' ),
                  F510 = dict(wert='D5' , kreuz='1' ),
                  G520 = dict(wert='D5' , kreuz='1' ),           # enharmonische Verwechslung fr F510
                  A500 = dict(wert='F5' , kreuz='1' ),
                  C600 = dict(wert='A5' , kreuz='1' ),
                  B510 = dict(wert='A5' , kreuz='1' ),           # enharmonische Verwechslung fr C600
                  D600 = dict(wert='C6' , kreuz='1' ),
                  F610 = dict(wert='E6' , kreuz='1' ),
                  G620 = dict(wert='E6' , kreuz='1' ),           # enharmonische Verwechslung fr F610
                  A600 = dict(wert='G6' , kreuz='1' ),
                  C700 = dict(wert='B6' , kreuz='1' ),
                  B610 = dict(wert='B6' , kreuz='1' ),           # enharmonische Verwechslung fr C700
                  E700 = dict(wert='D7' , kreuz='1' ),
                  F720 = dict(wert='D7' , kreuz='1' ),           # enharmonische Verwechslung fr E700
                  F710 = dict(wert='F7' , kreuz='1' ),
                  G720 = dict(wert='F7' , kreuz='1' )            # enharmonische Verwechslung fr F710
                  )
# Mitte Zug - A7 3-Reiher
mitteZugList  =   dict(
                  G400 = dict(wert='F4' , kreuz='0' ),
                  A400 = dict(wert='A4' , kreuz='0' ),
                  C510 = dict(wert='C5' , kreuz='0' ),
                  D520 = dict(wert='C5' , kreuz='0' ),           # enharmonische Verwechslung fr C510
                  E500 = dict(wert='E5' , kreuz='0' ),
                  F520 = dict(wert='E5' , kreuz='0' ),           # enharmonische Verwechslung fr E500
                  G500 = dict(wert='G5' , kreuz='0' ),
                  A500 = dict(wert='B5' , kreuz='0' ),
                  C610 = dict(wert='D6' , kreuz='0' ),
                  D620 = dict(wert='D6' , kreuz='0' ),           # enharmonische Verwechslung fr C610
                  E600 = dict(wert='F6' , kreuz='0' ),
                  F620 = dict(wert='F6' , kreuz='0' ),           # enharmonische Verwechslung fr E600
                  G600 = dict(wert='A6' , kreuz='0' ),
                  B600 = dict(wert='C7' , kreuz='0' ),
                  C720 = dict(wert='C7' , kreuz='0' ),           # enharmonische Verwechslung fr B600
                  C710 = dict(wert='E7' , kreuz='0' ),
                  D720 = dict(wert='E7' , kreuz='0' )            # enharmonische Verwechslung fr C710
                  )
# Mitte Zug - A7 4-Reiher
mitteZugList1 =   dict(
                  G400 = dict(wert='F4' , kreuz='0' ),
                  A400 = dict(wert='A4' , kreuz='0' ),
                  C510 = dict(wert='C5' , kreuz='0' ),
                  D520 = dict(wert='C5' , kreuz='0' ),           # enharmonische Verwechslung fr C510
                  E500 = dict(wert='E5' , kreuz='0' ),
                  F520 = dict(wert='E5' , kreuz='0' ),           # enharmonische Verwechslung fr E500
                  G500 = dict(wert='G5' , kreuz='0' ),
                  A500 = dict(wert='B5' , kreuz='0' ),
                  C610 = dict(wert='D6' , kreuz='0' ),
                  D620 = dict(wert='D6' , kreuz='0' ),           # enharmonische Verwechslung fr C610
                  E600 = dict(wert='F6' , kreuz='0' ),
                  F620 = dict(wert='F6' , kreuz='0' ),           # enharmonische Verwechslung fr E600
                  G600 = dict(wert='A6' , kreuz='0' ),
                  B600 = dict(wert='C7' , kreuz='0' ),
                  C720 = dict(wert='C7' , kreuz='0' ),           # enharmonische Verwechslung fr B600
                  C710 = dict(wert='E7' , kreuz='0' ),
                  D720 = dict(wert='E7' , kreuz='0' ),           # enharmonische Verwechslung fr C710
                  E700 = dict(wert='G7' , kreuz='0' ),
                  F720 = dict(wert='G7' , kreuz='0' )            # enharmonische Verwechslung fr E700
                  )
# Aussen Zug - E7 3-Reiher
aussenZugList  =  dict(
                  D400 = dict(wert='E4' , kreuz='0' ),
                  E400 = dict(wert='G4' , kreuz='0' ),
                  F420 = dict(wert='G4' , kreuz='0' ),           # enharmonische Verwechslung fr E400
                  G410 = dict(wert='B4' , kreuz='0' ),
                  A420 = dict(wert='B4' , kreuz='0' ),           # enharmonische Verwechslung fr G410
                  B400 = dict(wert='D5' , kreuz='0' ),
                  C520 = dict(wert='D5' , kreuz='0' ),           # enharmonische Verwechslung fr B400
                  D500 = dict(wert='F5' , kreuz='0' ),
                  F510 = dict(wert='A5' , kreuz='0' ),
                  G520 = dict(wert='A5' , kreuz='0' ),           # enharmonische Verwechslung fr F510
                  G510 = dict(wert='C6' , kreuz='0' ),
                  A520 = dict(wert='C6' , kreuz='0' ),           # enharmonische Verwechslung fr G510
                  B500 = dict(wert='E6' , kreuz='0' ),
                  C620 = dict(wert='E6' , kreuz='0' ),           # enharmonische Verwechslung fr B500
                  D600 = dict(wert='G6' , kreuz='0' ),
                  F610 = dict(wert='B6' , kreuz='0' ),
                  G620 = dict(wert='B6' , kreuz='0' ),           # enharmonische Verwechslung fr F610
                  G610 = dict(wert='D7' , kreuz='0' ),
                  A620 = dict(wert='D7' , kreuz='0' ),           # enharmonische Verwechslung fr G610
                  B600 = dict(wert='F7' , kreuz='0' ),
                  C720 = dict(wert='F7' , kreuz='0' )            # enharmonische Verwechslung fr B600
                  )
# Aussen Zug - E7 4-Reiher
aussenZugList1 =  dict(
                  D400 = dict(wert='E4' , kreuz='0' ),
                  E400 = dict(wert='G4' , kreuz='0' ),
                  F420 = dict(wert='G4' , kreuz='0' ),           # enharmonische Verwechslung fr E400
                  G410 = dict(wert='B4' , kreuz='0' ),
                  A420 = dict(wert='B4' , kreuz='0' ),           # enharmonische Verwechslung fr G410
                  B400 = dict(wert='D5' , kreuz='0' ),
                  C520 = dict(wert='D5' , kreuz='0' ),           # enharmonische Verwechslung fr B400
                  D500 = dict(wert='F5' , kreuz='0' ),
                  F510 = dict(wert='A5' , kreuz='0' ),
                  G520 = dict(wert='A5' , kreuz='0' ),           # enharmonische Verwechslung fr F510
                  G510 = dict(wert='C6' , kreuz='0' ),
                  A520 = dict(wert='C6' , kreuz='0' ),           # enharmonische Verwechslung fr G510
                  B500 = dict(wert='E6' , kreuz='0' ),
                  C620 = dict(wert='E6' , kreuz='0' ),           # enharmonische Verwechslung fr B500
                  D600 = dict(wert='G6' , kreuz='0' ),
                  F610 = dict(wert='B6' , kreuz='0' ),
                  G620 = dict(wert='B6' , kreuz='0' ),           # enharmonische Verwechslung fr F610
                  G610 = dict(wert='D7' , kreuz='0' ),
                  A620 = dict(wert='D7' , kreuz='0' ),           # enharmonische Verwechslung fr G610
                  B600 = dict(wert='F7' , kreuz='0' ),
                  C720 = dict(wert='F7' , kreuz='0' ),           # enharmonische Verwechslung fr B600
                  D700 = dict(wert='A7' , kreuz='0' )
                  )
# Aussnahmeliste Zug:  beide Versionen mssen eingetragen werden ! aaaabbbb und bbbbaaaa 
exceptionListZ =  dict(
                  G510F610 = 'C610F610',F610G510 = 'C610F610',
                  F510E610 = 'B500E610',E610F510 = 'B500E610',
                  G600F700 = 'G600C700',F700G600 = 'G600C700',
                  C500B500 = 'C500F510',B500C500 = 'C500F510',
                  C610G610 = 'D600G610',G610C610 = 'D600G610',
                  E600B600 = 'E600A600',B600E500 = 'E600A600',
                  A400F500 = 'A400D510',F500A400 = 'A400D510'
                  )

# Aussnahmeliste Druck:  beide Versionen mssen eingetragen werden ! aaaabbbb und bbbbaaaa 
exceptionListD =  dict(
                  D510A510 = 'E500A510',A510D510 = 'E500A510'
                  )

#xx = druckList['D300']['wert']  #so wird das Dictionary abgefragt

# y Offset der Notenkpfe

KopfOffset = dict(E4 = '+5.5',F4 = '+5',G4 = '+4.5',A4 = '+4', B4 = '+3.5',
                  C5 = '+3',D5 = '+2.5',E5 ='+2',F5 = '+1.5',G5 = '+1',A5 = '+0.5',B5 ='0',
                  C6 = '-0.5',D6 = '-1',E6 = '-1.5',F6 = '-2',G6 = '-2.5',A6 = '-3',B6 = '-3.5',B7 = '-7',
                  C7 = '-4',D7 = '-4.5',E7 = '-5',F7 = '-5.5',G7 = '-6',A7 ='-6.5')

def getTime(score):
    if score.getElementsByTagName('timeSign'):
        ts = score.getElementsByTagName('timeSign')[0]
        t  = ts.getAttribute('time')
        return(t)
    else:
        #messageBox('Time','Taktangabe fehlt, 4/4 wird angenommen')
        return('x')

def addElementNode(el,tagName):
    # Neue Node zu "el" hinzufgen wenn Node "tagName" nicht existiert
    # ansonsten existierende Node zurckmelden
    global doc
    childs = el.childNodes
    for n in range(childs.length):
        if childs[n].nodeType ==childs[n].ELEMENT_NODE and childs[n].tagName == tagName:
            return childs[n]
    newChild = doc.createElement(tagName)
    el.appendChild(newChild)
    return newChild

def addNewElementNode(el,tagName):
    # add new Node with tagName "tagName" to el 
    global doc
    newChild = doc.createElement(tagName)
    el.appendChild(newChild)
    return newChild

def getElementObjects(objList):  # returns a List
    newList = NodeList()         
    for n in range(objList.length):
        if objList[n].nodeType == objList[n].ELEMENT_NODE:
            newList.append(objList[n])
    return newList

def makeIndex(head):                                                   # Index fr druckList oder zugList erzeugen
    alter = head.getElementsByTagName('alter')
    pitch = head.getAttribute('pitch')
    if alter:
        if alter[0].hasAttribute('step'):
            step = str(alter[0].getAttribute('step'))
        else: step = '0'
    else: step = '0'
    if step == '-1':
        step = '2'
    index = str(pitch) + str(step) + '0'
    #messageBox('Index',str(index))
    return index

def insertHead(head,hd,wt,kz,chord,score):

    global darSize
    
    kreuzPos = dict(
                    ADG = dict(G4='+4.5' , B4='+3.5', D5='+2.5', F5='+1.5', A5='+0.5', C6='-0.5', E6='-1.5', G6='-2.5', B6='-3.5', D7='-4.5', F7='-5.5',
                               A4='+4'   , C5='+3'  , E5='+2'  , G5='+1'  , B5='0'   , D6='-1'  , F6='-2'  , A6='-3'  , C7='-4'  , E7='-5')
                    )
    alter = head[hd].getElementsByTagName('alter')
    if alter:
        if alter[0].hasAttribute('display'):
            alter[0].removeAttribute('display')                        # alte Tags lschen
    if head[hd].hasAttribute('shape'):
        head[hd].removeAttribute('shape')#
    head[hd].setAttribute('pitch',wt)                                  # Note ersetzen
    if kz == '1':                                                      # <--- wenn kz=1 dann Kreuz machen
        ton = makeIndex(head[hd])[0:2]
        y   = kreuzPos['ADG'][ton]
        drawObjects = addElementNode(chord,'drawObjects')
        drawObj     = addNewElementNode(drawObjects,'drawObj')
        text        = addNewElementNode(drawObj,'text')
        font        = addNewElementNode(text,'font')
        content     = addNewElementNode(text,'content')
        font.setAttribute('face','capella3')
        #font.setAttribute('height','18')
        font.setAttribute('height',str(darSize))
        font.setAttribute('charSet','2')
        font.setAttribute('pitchAndFamily','2')     
        text.setAttribute('y',str(y))

        if int(darSize) >= 18:
            horPos = '-1.15'
        elif int(darSize) >= 16:
            horPos ='-1.075'
        elif int(darSize) >= 14:
            horPos ='-1'
        elif int(darSize) >= 12:
            horPos ='-0.875'
        else:
            horPos = '-0.8'
            
        if darKopf == 0:                                               # klassische Kopf-Darstellung
            #text.setAttribute('x','-1.15')
            text.setAttribute('x',str(horPos))
        else:                                                          # alternative Kopf-Darstellung
            duration = head[hd].parentNode.parentNode.getElementsByTagName('duration')
            base = str(duration[0].getAttribute('base'))
            if base == '1/2' or base == '1/1' or base == '2/1':
                #text.setAttribute('x','-1.15')                         # ausser bei 1/2, 1/1 oder 2/1 Noten
                text.setAttribute('x',horPos)
            else:    
                text.setAttribute('x','0')
                head[hd].setAttribute('shape','none')
      
        content.appendChild(score.parentNode.createTextNode('T'))
    if alter:    
        alter[0].setAttribute('step','0')

def ProcessExceptionList(score):
    global aDir
    systems = score.getElementsByTagName('system')
    for sy in range(systems.length):
        staves = systems[sy].getElementsByTagName('staff')
        for st in range(staves.length):
            layout = staves[st].getAttribute('layout')
            if layout == 'Tabulatur':
                #messageBox('Layout',str(layout))
                voices = staves[st].getElementsByTagName('voice')
                for vo in range(voices.length):
                    noteObjects = getElementObjects(voices[vo].getElementsByTagName('noteObjects')[0].childNodes)
                    for no in range(noteObjects.length):
                        if noteObjects[no].tagName == 'chord':
                            pitch    = []   # Tonhhe der Kpfe am Notenhals
                            pos      = []   # y-Position vorhandener DrawObjects am Notenhals
                            headE    = []   # Kopf, Elemente am Notenhals
                            kreuz    = []   # Kopf hat Kreuz, yes/no
                            heads = noteObjects[no].getElementsByTagName('head')
                            for hd in range(heads.length):
                                basic = noteObjects[no].getElementsByTagName('basic')   # Feststellung ob Druck oder Zug
                                for ba in range(basic.length):                          # abhngig von Begleitakkord
                                    if basic[ba].hasAttribute('tag'):
                                        tag = basic[ba].getAttribute('tag')
                                        if tag == '2086-31' or tag == '2086-32' or tag == '2086-33' or tag == '2086-34' or tag == '2086-41' or tag == '2086-42' or tag == '2086-43' or tag == '2086-44':
                                            if tag == '2086-31' or tag == '2086-32' or tag == '2086-33' or tag == '2086-34':
                                                aDir = 'D'
                                            elif tag == '2086-41' or tag == '2086-42' or tag == '2086-43' or tag == '2086-44':
                                                aDir = 'Z'
                                                
                                pitch1 = heads[hd].getAttribute('pitch')
                                pitch.append(str(pitch1))
                                headE.append(heads[hd])                                  # Kopf Liste erzeugen
                                #messageBox('HD',str(headE))
                            for do in noteObjects[no].getElementsByTagName('drawObj'):   # Kreuze feststellen und Position merken
                                for tx in do.getElementsByTagName('text'):
                                    if tx:
                                        y  = tx.getAttribute('y') 
                                        font = tx.getElementsByTagName('font')
                                        face = font[0].getAttribute('face')                                       
                                        if face == 'capella3':
                                            content = tx.getElementsByTagName('content')
                                            data = content[0].firstChild.data
                                            if data == 'T':                              
                                                pos.append(str(y))                      # y-Position merken
                                                #messageBox('pos',str(pos))
                                                           
                            if pitch:
                                #messageBox('NOs',str(pitch) + '\n' + str(pos) + '\n' + str(heads))
                                for ix1 in range(len(pitch)):                            # testen ob Ton ein Kreuz hat
                                    if KopfOffset.has_key(pitch[ix1]):
                                        #messageBox('Index',str(pitch[ix1]) + '      OK')
                                        off = KopfOffset[pitch[ix1]]
                                        for ix2 in range(len(heads)):                        # testen ob Offset des Kopfes fr ein Kreuz vorhanden ist
                                            if off in pos:
                                                kr = 'yes'
                                            else:
                                                kr = 'no'
                                    else:
                                        #messageBox('Index',str(pitch[ix1]) + '      not OK')
                                        kr = 'xx'
                                    #messageBox('OFF',str(pitch[ix1]) + '\n' + str(off) + '\n' + str(pos))
                                    kreuz.append(kr)                                     # merken welcher Kopf ein Kreuz hat und welcher nicht
                                    #messageBox('kr',str(kr))
                            #messageBox('NOs',str(pitch) + '\n' + str(pos) + '\n' + str(heads) + '\n' + str(kreuz) + '\n' + str(aDir))
                            index = ''
                            for ix2 in range(len(heads)):                                # Index erzeugen
                                index = index + pitch[ix2]
                                if kreuz[ix2] == 'yes':
                                    index = index + '10'
                                elif kreuz[ix2] == 'no':
                                    index = index + '00'
                                else:
                                    index = index + '11'                                 # ungltiger Ton
                            
                            replacement = ''                                             # Alternativliste abfragen
                            if aDir == 'D' and exceptionListD.has_key(index) and exDruck == 1:
                                replacement = exceptionListD[index]
                            if aDir == 'Z' and exceptionListZ.has_key(index) and exZug == 1:
                                replacement = exceptionListZ[index]
                                                          
                            #messageBox('Index',str(index) + '\n' + str(replacement))
                            if replacement <> '':                                        # Kpfe ersetzen
                                
                                dOs = noteObjects[no].getElementsByTagName('drawObj')    # alte Kreuze entfernen
                                for do in range(dOs.length):
                                    content = dOs[do].getElementsByTagName('content')
                                    for ct in range(content.length):
                                        cnt = str(content[ct])
                                        data = content[ct].firstChild.data                                   
                                        if data == 'T':
                                            d=dOs[do]
                                            d.parentNode.removeChild(d)   
                                x = 0
                                y = 2
                                z = 2
                                w = 3
                                for ix3 in range(len(heads)):
                                    #messageBox('REP',str(replacement[z:w]))
                                    insertHead(heads,ix3,replacement[x:y],replacement[z:w],noteObjects[no],score)
                                    x = x+4
                                    y = y+4
                                    z = z+4
                                    w = w+4
    return 

#3-Reiher    
def analyseHeads1(score,head,chord,direction):
    global doc, dCnt, zCnt, aDir, darNicht, darKopf, darAuftakt, aDir

    #messageBox('Richtung',str(direction))
    kreuzPos = dict(
                    ADG = dict(G4='+4.5' , B4='+3.5', D5='+2.5', F5='+1.5', A5='+0.5', C6='-0.5', E6='-1.5', G6='-2.5', B6='-3.5', D7='-4.5')
                    )

    #xx = kreuzPos['ADG'][G4]  #so wird das Dictionary abgefragt

    DrList       = []
    ZgList       = []
    PosList      = []
    lHvalid      = 0

    for hd in range(head.length):                 # wo lsst sich dieser Ton greifen ?
        index = makeIndex(head[hd])
        PosList.append(str(index))
       
        if mitteDruckList.has_key(index):
            PosList.append('DM')
        else:
            PosList.append('XX')    
        if innenDruckList.has_key(index):
            PosList.append('DI')
        else:
            PosList.append('XX')
        if aussenDruckList.has_key(index):
            PosList.append('DA')
        else:
            PosList.append('XX')
        if mitteZugList.has_key(index):
            PosList.append('ZM')
        else:
            PosList.append('XX')
        if innenZugList.has_key(index):
            PosList.append('ZI')
        else:
            PosList.append('XX')
        if aussenZugList.has_key(index):
            PosList.append('ZA')
        else:
            PosList.append('XX')

    #messageBox('PosList',str(PosList) + '  ' + str(len(PosList)))

    oDM = 'LE'
    oDI = 'LE'
    oDA = 'LE'
    oZM = 'LE'
    oZI = 'LE'
    oZA = 'LE'

    for ix in range(len(PosList)/7):                                           # wo lsst sich der Akkord greifen ?
        if oDM == 'LE':
            oDM = PosList[ix*7+1]
        else:
            if oDM <> PosList[ix*7+1]:
                oDM = 'XX'
        if oDI == 'LE':
            oDI = PosList[ix*7+2]
        else:
            if oDI <> PosList[ix*7+2]:
                oDI = 'XX'                
        if oDA == 'LE':
            oDA = PosList[ix*7+3]
        else:
            if oDA <> PosList[ix*7+3]:
                oDA = 'XX'
        if oZM == 'LE':
            oZM = PosList[ix*7+4]
        else:
            if oZM <> PosList[ix*7+4]:
                oZM = 'XX'
        if oZI == 'LE':
            oZI = PosList[ix*7+5]
        else:
            if oZI <> PosList[ix*7+5]:
                oZI = 'XX'                
        if oZA == 'LE':
            oZA = PosList[ix*7+6]
        else:
            if oZA <> PosList[ix*7+6]:
                oZA = 'XX'
    #messageBox('WO',str(direction) + ' ' +str(aDir) + '\n' + str(oDI) + str(oDM) + str(oDA) + str(oZI) + str(oZM) + str(oZA))            
    
    for hd in range(head.length):                                              # in Griffschrift umwandeln
        index = makeIndex(head[hd])
        alter = head[hd].getElementsByTagName('alter')    
        if aDir == 'N' and darAuftakt == 0:                                    # Richtung bei Auftakt ohne Akkord
            aDir = 'D'                                                         # vorgeben
        if aDir == 'N' and darAuftakt == 1:
            aDir = 'Z'
        if aDir == 'D':
            #messageBox('Druck',str(aDir))
            if direction == 'I':                                               # bevorzugt Innen
                
                if oDI == 'DI':                                                # Akkord auf Druck Innen
                    wt = innenDruckList[index]['wert']
                    kz = innenDruckList[index]['kreuz']
                    richtung = 'D'
                elif innenDruckList.has_key(index):                            # Kreuzgriff Druck Innen         
                    wt = innenDruckList[index]['wert']
                    kz = innenDruckList[index]['kreuz']
                    richtung = 'D'
                elif mitteDruckList.has_key(index):                            # Kreuzgriff Druck Mitte         
                    wt = mitteDruckList[index]['wert']
                    kz = mitteDruckList[index]['kreuz']
                    richtung = 'D'
                elif aussenDruckList.has_key(index):                           # Kreuzgriff Druck Aussen         
                    wt = aussenDruckList[index]['wert']
                    kz = aussenDruckList[index]['kreuz']
                    richtung = 'D'                                               
                else:
                    wt = 'XX'                                                  # Ton nicht auf Druck
                    kz = 'XX'
                    richtung = 'X'
                    
            if direction == 'M':                                               # bevorzugt Mitte

                if oDM == 'DM':                                                # Akkord auf Druck Mitte
                    wt = mitteDruckList[index]['wert']
                    kz = mitteDruckList[index]['kreuz']
                    richtung = 'D'                
                elif oDI == 'DI':                                              # Akkord auf Druck Innen
                    wt = innenDruckList[index]['wert']
                    kz = innenDruckList[index]['kreuz']
                    richtung = 'D'
                elif oDA == 'DA':                                              # Akkord auf Druck Aussen
                    wt = aussenDruckList[index]['wert']
                    kz = aussenDruckList[index]['kreuz']
                    richtung = 'D'
                elif mitteDruckList.has_key(index):                            # Kreuzgriff Druck Mitte         
                    wt = mitteDruckList[index]['wert']
                    kz = mitteDruckList[index]['kreuz']
                    richtung = 'D'
                elif innenDruckList.has_key(index):                            # Kreuzgriff Druck Innen         
                    wt = innenDruckList[index]['wert']
                    kz = innenDruckList[index]['kreuz']
                    richtung = 'D'
                elif aussenDruckList.has_key(index):                           # Kreuzgriff Druck Aussen         
                    wt = aussenDruckList[index]['wert']
                    kz = aussenDruckList[index]['kreuz']
                    richtung = 'D'                                               
                else:
                    wt = 'XX'                                                  # Ton nicht auf Druck
                    kz = 'XX'
                    richtung = 'X'

            if direction == 'A':                                               # bevorzugt Aussen

                if oDA == 'DA':                                                # Akkord auf Druck Aussen
                    wt = aussenDruckList[index]['wert']
                    kz = aussenDruckList[index]['kreuz']
                    richtung = 'D'
                elif oDM == 'DM':                                              # Akkord auf Druck Mitte
                    wt = mitteDruckList[index]['wert']
                    kz = mitteDruckList[index]['kreuz']
                    richtung = 'D'                
                elif oDI == 'DI':                                              # Akkord auf Druck Innen
                    wt = innenDruckList[index]['wert']
                    kz = innenDruckList[index]['kreuz']
                    richtung = 'D'
                elif aussenDruckList.has_key(index):                           # Kreuzgriff Druck Aussen         
                    wt = aussenDruckList[index]['wert']
                    kz = aussenDruckList[index]['kreuz']
                    richtung = 'D'   
                elif mitteDruckList.has_key(index):                            # Kreuzgriff Druck Mitte         
                    wt = mitteDruckList[index]['wert']
                    kz = mitteDruckList[index]['kreuz']
                    richtung = 'D'
                elif innenDruckList.has_key(index):                            # Kreuzgriff Druck Innen         
                    wt = innenDruckList[index]['wert']
                    kz = innenDruckList[index]['kreuz']
                    richtung = 'D'   
                else:
                    wt = 'XX'                                                  # Ton nicht auf Druck
                    kz = 'XX'
                    richtung = 'X'                    
                    
        elif aDir == 'Z':                                                      # Zug
            #messageBox('Zug',str(aDir))
            if direction == 'I':                                               # bevorzugt Innen
                if oZI == 'ZI':                                                # Akkord auf Zug Innen
                    wt = innenZugList[index]['wert']
                    kz = innenZugList[index]['kreuz']
                    richtung = 'Z'
                elif innenZugList.has_key(index):                              # Kreuzgriff Zug Innen         
                    wt = innenZugList[index]['wert']
                    kz = innenZugList[index]['kreuz']
                    richtung = 'Z'
                elif mitteZugList.has_key(index):                              # Kreuzgriff Zug Mitte         
                    wt = mitteZugList[index]['wert']
                    kz = mitteZugList[index]['kreuz']
                    richtung = 'Z'
                elif aussenZugList.has_key(index):                             # Kreuzgriff Zug Aussen         
                    wt = aussenZugList[index]['wert']
                    kz = aussenZugList[index]['kreuz']
                    richtung = 'Z' 
                else:
                    wt = 'XX'                                                  # Ton nicht auf Zug
                    kz = 'XX'
                    richtung = 'X'

            if direction == 'M':                                               # bevorzugt Innen
                if oZM == 'ZM':                                                # Akkord auf Zug Mitte
                    wt = mitteZugList[index]['wert']
                    kz = mitteZugList[index]['kreuz']
                    richtung = 'Z'
                elif oZI == 'ZI':                                              # Akkord auf Zug Innen
                    wt = innenZugList[index]['wert']
                    kz = innenZugList[index]['kreuz']
                    richtung = 'Z'
                elif oZA == 'ZA':                                              # Akkord auf Zug Aussen
                    wt = aussenZugList[index]['wert']
                    kz = aussenZugList[index]['kreuz']
                    richtung = 'Z'
                elif mitteZugList.has_key(index):                              # Kreuzgriff Zug Mitte         
                    wt = mitteZugList[index]['wert']
                    kz = mitteZugList[index]['kreuz']
                    richtung = 'Z'
                elif aussenZugList.has_key(index):                             # Kreuzgriff Zug Aussen         
                    wt = aussenZugList[index]['wert']
                    kz = aussenZugList[index]['kreuz']
                    richtung = 'Z'            
                elif innenZugList.has_key(index):                              # Kreuzgriff Zug Innen         
                    wt = innenZugList[index]['wert']
                    kz = innenZugList[index]['kreuz']
                    richtung = 'Z'
                else:
                    wt = 'XX'                                                  # Ton nicht auf Zug
                    kz = 'XX'
                    richtung = 'X'

            if direction == 'A':                                               # bevorzugt Aussen
                if oZA == 'ZA':                                                # Akkord auf Zug Aussen
                    wt = aussenZugList[index]['wert']
                    kz = aussenZugList[index]['kreuz']
                    richtung = 'Z'
                elif oZM == 'ZM':                                              # Akkord auf Zug Mitte
                    wt = mitteZugList[index]['wert']
                    kz = mitteZugList[index]['kreuz']
                    richtung = 'Z'
                elif oZI == 'ZI':                                              # Akkord auf Zug Innen
                    wt = innenZugList[index]['wert']
                    kz = innenZugList[index]['kreuz']
                    richtung = 'Z'
                elif aussenZugList.has_key(index):                             # Kreuzgriff Zug Aussen         
                    wt = aussenZugList[index]['wert']
                    kz = aussenZugList[index]['kreuz']
                    richtung = 'Z'                 
                elif mitteZugList.has_key(index):                              # Kreuzgriff Zug Mitte         
                    wt = mitteZugList[index]['wert']
                    kz = mitteZugList[index]['kreuz']
                    richtung = 'Z'   
                elif innenZugList.has_key(index):                              # Kreuzgriff Zug Innen         
                    wt = innenZugList[index]['wert']
                    kz = innenZugList[index]['kreuz']
                    richtung = 'Z'
                else:
                    wt = 'XX'                                                  # Ton nicht auf Zug
                    kz = 'XX'
                    richtung = 'X'
        else:
            wt = 'XX'                                                          # Ton nicht auf dem Instrument
            kz = 'XX'
            richtung = 'X'
            
        if richtung <> 'X':
            insertHead(head,hd,wt,kz,chord,score)                              # Kopf einfgen
        else:        
            if lHvalid == 0:
                lH      = len(head)
                lHvalid = 1
            #messageBox('Start',str(lH) + '  ' + str(hd))
            if darNicht == 1:                                                  # wenn rot frben
                new = addElementNode(head[hd].parentNode.parentNode,'display') # Original Note anzeigen und
                new.setAttribute('color',str('E00050'))                        # rot einfrben

            elif darNicht == 0 and lH > 1:                                     # wenn entfernen
                x = head[hd].parentNode.removeChild(head[hd])                  # Kopf entfernen
                lH = lH - 1
                #messageBox('Kopf entfernt',str(len(head)) + '  ' + str(hd))
            
            elif darNicht == 0 and lH == 1:                                    # ausser wenn letzter
                #messageBox('ROT','rot frben')
                new = addElementNode(head[hd].parentNode.parentNode,'display') # Original Note anzeigen und
                new.setAttribute('color',str('E00050'))                        # rot einfrben
                       
        #messageBox('Richtung',str(richtung ))

        if richtung == 'D':                                                    # wenn Druck, dann Balken anzeigen
            dObjs = chord.getElementsByTagName('drawObjects')
            if dObjs.length == 0:                                              # falls noch keine drawObjects da sind
                new = addElementNode(head[hd].parentNode.parentNode,'drawObjects')
                dO  = addElementNode(new,'drawObj')
            else:
                dO = doc.createElement('drawObj')                              # falls bereits drawObjects vorhanden sind
                dObjs[0].appendChild(dO)
 
            line = addElementNode(dO,'line')
            y1 = 10.875 - 8 + float(tzlOben) + float(tzlUnten)
            line.setAttribute('x1','-0.5')
            line.setAttribute('x2','0.5')
            line.setAttribute('y1',str(y1))
            line.setAttribute('y2',str(y1))
            line.setAttribute('lineWidth','0.5')

    for hd in range(head.length):                                              # eventuelle Vorzeichen in Tabulatur unterdrcken 
        altsup = addElementNode(head[hd],'alter')
        altsup.setAttribute('display','suppress' )

    return

#4-Reiher
def analyseHeads2(score,head,chord,direction):
    global doc, dCnt, zCnt, aDir, darNicht, darKopf, darAuftakt, aDir

    #messageBox('analyseHeads2',str(direction))
    kreuzPos = dict(
                    ADG = dict(G4='+4.5' , B4='+3.5', D5='+2.5', F5='+1.5', A5='+0.5', C6='-0.5', E6='-1.5', G6='-2.5', B6='-3.5', D7='-4.5', F7='-5.5',
                               A4='+4'   , C5='+3'  , E5='+2'  , G5='+1'  , B5='0'   , D6='-1'  , F6='-2'  , A6='-3'  , C7='-4'  , E7='-5')
                    )

    #xx = kreuzPos['ADG'][G4]  #so wird das Dictionary abgefragt

    DrList       = []
    ZgList       = []
    PosList      = []
    lHvalid      = 0

    for hd in range(head.length):                 # wo lsst sich dieser Ton greifen ?
        index = makeIndex(head[hd])
        PosList.append(str(index))
       
        if mitteDruckList1.has_key(index):
            PosList.append('DM')
        else:
            PosList.append('XX')    
        if innenDruckList1.has_key(index):
            PosList.append('DI')
        else:
            PosList.append('XX')
        if aussenDruckList1.has_key(index):
            PosList.append('DA')
        else:
            PosList.append('XX')
        if giDruckList1.has_key(index):
            PosList.append('DZ')
        else:
            PosList.append('XX')
            
        if mitteZugList1.has_key(index):
            PosList.append('ZM')
        else:
            PosList.append('XX')
        if innenZugList1.has_key(index):
            PosList.append('ZI')
        else:
            PosList.append('XX')
        if aussenZugList1.has_key(index):
            PosList.append('ZA')
        else:
            PosList.append('XX')
        if giZugList1.has_key(index):
            PosList.append('ZZ')
        else:
            PosList.append('XX')

        # PosList xxxx , aa , bb, cc, dd, ee, ff, xxxx , aa , bb, ....
        # xxxx = index
        # aa,..= DM, DI etc
        # len(PosList)   = 0-x Anzahl der Elemente in der Liste
        # PosList[0]     = erstes Element der PosList
        # len(PosList[0]) = Lnge des ersten Elementes, wenn 4 dann Index wenn 2 dann Eintrag
    #messageBox('PosList',str(PosList) + '  ' + str(len(PosList)))

    oDM = 'LE'
    oDI = 'LE'
    oDA = 'LE'
    oDZ = 'LE'
    oZM = 'LE'
    oZI = 'LE'
    oZA = 'LE'
    oZZ = 'LE'

    for ix in range(len(PosList)/9):                                           # wo lsst sich der Akkord greifen ?
        if oDM == 'LE':
            oDM = PosList[ix*9+1]
        else:
            if oDM <> PosList[ix*9+1]:
                oDM = 'XX'
        if oDI == 'LE':
            oDI = PosList[ix*9+2]
        else:
            if oDI <> PosList[ix*9+2]:
                oDI = 'XX'                
        if oDA == 'LE':
            oDA = PosList[ix*9+3]
        else:
            if oDA <> PosList[ix*9+3]:
                oDA = 'XX'
        if oDZ == 'LE':
            oDZ = PosList[ix*9+4]
        else:
            if oDZ <> PosList[ix*9+4]:
                oDZ = 'XX'
        if oZM == 'LE':
            oZM = PosList[ix*9+5]
        else:
            if oZM <> PosList[ix*9+5]:
                oZM = 'XX'
        if oZI == 'LE':
            oZI = PosList[ix*9+6]
        else:
            if oZI <> PosList[ix*9+6]:
                oZI = 'XX'                
        if oZA == 'LE':
            oZA = PosList[ix*9+7]
        else:
            if oZA <> PosList[ix*9+7]:
                oZA = 'XX'
        if oZZ == 'LE':
            oZZ = PosList[ix*9+8]
        else:
            if oZZ <> PosList[ix*9+8]:
                oZZ = 'XX'
    #messageBox('WO',str(direction) + ' ' +str(aDir) + '\n' + str(oDI) + str(oDM) + str(oDA) + str(oDZ) + str(oZI) + str(oZM) + str(oZA)+ str(oZZ))            
    
    for hd in range(head.length):                                              # in Griffschrift umwandeln
        index = makeIndex(head[hd])
        alter = head[hd].getElementsByTagName('alter')
        if aDir == 'N' and darAuftakt == 0:                                    # Richtung bei Auftakt ohne
            aDir = 'D'                                                         # Akkord vorgeben
        if aDir == 'N' and darAuftakt == 1:
            aDir = 'Z'
        if aDir == 'D':
            if direction == 'I':                                               # bevorzugt Innen
                if oDI == 'DI':                                                # Akkord auf Druck Innen
                    wt = innenDruckList1[index]['wert']
                    kz = innenDruckList1[index]['kreuz']
                    richtung = 'D'
                elif oDZ == 'DZ':                                              # Akkord auf F-Reihe (ganz innen)
                    wt = giDruckList1[index]['wert']
                    kz = giDruckList1[index]['kreuz']
                    richtung = 'D'
                elif oDM == 'DM':                                              # Akkord auf Druck Mitte
                    wt = mitteDruckList1[index]['wert']
                    kz = mitteDruckList1[index]['kreuz']
                    richtung = 'D'
                elif innenDruckList1.has_key(index):                           # Kreuzgriff Druck Innen         
                    wt = innenDruckList1[index]['wert']
                    kz = innenDruckList1[index]['kreuz']
                    richtung = 'D'
                elif giDruckList1.has_key(index):                              # Kreuzgriff Druck F-Reihe (ganz innen)         
                    wt = giDruckList1[index]['wert']
                    kz = giDruckList1[index]['kreuz']
                    richtung = 'D'
                elif mitteDruckList1.has_key(index):                           # Kreuzgriff Druck Mitte         
                    wt = mitteDruckList1[index]['wert']
                    kz = mitteDruckList1[index]['kreuz']
                    richtung = 'D'
                elif aussenDruckList1.has_key(index):                          # Kreuzgriff Druck Aussen         
                    wt = aussenDruckList1[index]['wert']
                    kz = aussenDruckList1[index]['kreuz']                      # falsche Drucklist Abfrage 4.1.15  21.9.14
                    richtung = 'D'
                else:
                    wt = 'XX'                                                  # Ton nicht auf Druck
                    kz = 'XX'
                    richtung = 'X'
                    
            if direction == 'M':                                               # bevorzugt Mitte
                if oDM == 'DM':                                                # Akkord auf Druck Mitte
                    wt = mitteDruckList1[index]['wert']
                    kz = mitteDruckList1[index]['kreuz']
                    richtung = 'D'
                elif oDI == 'DI':                                              # Akkord auf Druck Innen
                    wt = innenDruckList1[index]['wert']
                    kz = innenDruckList1[index]['kreuz']
                    richtung = 'D'
                elif oDA == 'DA':                                              # Akkord auf Druck Aussen
                    wt = aussenDruckList1[index]['wert']
                    kz = aussenDruckList1[index]['kreuz']
                    richtung = 'D'
                elif mitteDruckList1.has_key(index):                           # Kreuzgriff Druck Mitte         
                    wt = mitteDruckList1[index]['wert']
                    kz = mitteDruckList1[index]['kreuz']
                    richtung = 'D'
                elif innenDruckList1.has_key(index):                           # Kreuzgriff Druck Innen         
                    wt = innenDruckList1[index]['wert']
                    kz = innenDruckList1[index]['kreuz']
                    richtung = 'D'
                elif aussenDruckList1.has_key(index):                          # Kreuzgriff Druck Aussen         
                    wt = aussenDruckList1[index]['wert']
                    kz = aussenDruckList1[index]['kreuz']
                    richtung = 'D'
                elif giDruckList1.has_key(index):                              # Kreuzgriff Reihe-F (ganz innen)      
                    wt = giDruckList1[index]['wert']                             
                    kz = giDruckList1[index]['kreuz']                            
                    richtung = 'D'
                else:
                    wt = 'XX'                                                  # Ton nicht auf Druck
                    kz = 'XX'
                    richtung = 'X'

            if direction == 'A':                                               # bevorzugt Aussen

                if oDA == 'DA':                                                # Akkord auf Druck Aussen
                    wt = aussenDruckList1[index]['wert']
                    kz = aussenDruckList1[index]['kreuz']
                    richtung = 'D'
                elif oDM == 'DM':                                              # Akkord auf Druck Mitte
                    wt = mitteDruckList1[index]['wert']
                    kz = mitteDruckList1[index]['kreuz']
                    richtung = 'D'                
                elif oDI == 'DI':                                              # Akkord auf Druck Innen
                    wt = innenDruckList1[index]['wert']
                    kz = innenDruckList1[index]['kreuz']
                    richtung = 'D'
                elif aussenDruckList1.has_key(index):                          # Kreuzgriff Druck Aussen         
                    wt = aussenDruckList1[index]['wert']
                    kz = aussenDruckList1[index]['kreuz']
                    richtung = 'D'   
                elif mitteDruckList1.has_key(index):                           # Kreuzgriff Druck Mitte         
                    wt = mitteDruckList1[index]['wert']
                    kz = mitteDruckList1[index]['kreuz']
                    richtung = 'D'
                elif innenDruckList1.has_key(index):                           # Kreuzgriff Druck Innen         
                    wt = innenDruckList1[index]['wert']
                    kz = innenDruckList1[index]['kreuz']
                    richtung = 'D'
                elif giDruckList1.has_key(index):                              # Kreuzgriff Reihe-F (ganz innen)      
                    wt = giDruckList1[index]['wert']
                    kz = giDruckList1[index]['kreuz']
                    richtung = 'D' 
                else:
                    wt = 'XX'                                                  # Ton nicht auf Druck
                    kz = 'XX'
                    richtung = 'X'

            if direction == 'Z':                                               # bevorzugt ganz innen
                if oDZ == 'DZ':                                                # Akkord auf Reihe-F (ganz innen)
                    wt = giDruckList1[index]['wert']
                    kz = giDruckList1[index]['kreuz']
                    richtung = 'D'
                elif giDruckList1.has_key(index):                              # Kreuzgriff Reihe-F  (ganz innen)      
                    wt = giDruckList1[index]['wert'] 
                    kz = giDruckList1[index]['kreuz']
                    richtung = 'D'
                elif innenDruckList1.has_key(index):                           # Kreuzgriff Druck Innen         
                    wt = innenDruckList1[index]['wert']
                    kz = innenDruckList1[index]['kreuz']
                    richtung = 'D'
                elif mitteDruckList1.has_key(index):                           # Kreuzgriff Druck Mitte         
                    wt = mitteDruckList1[index]['wert']
                    kz = mitteDruckList1[index]['kreuz']
                    richtung = 'D'
                elif aussenDruckList1.has_key(index):                          # Kreuzgriff Druck Aussen         
                    wt = aussenDruckList1[index]['wert']
                    kz = aussenDruckList1[index]['kreuz']
                    richtung = 'D'
                else:
                    wt = 'XX'                                                  # Ton nicht auf Druck
                    kz = 'XX'
                    richtung = 'X'                    
                    
        elif aDir == 'Z':                                                      # Zug
            if direction == 'I':                                               # bevorzugt Innen
                if oZI == 'ZI':                                                # Akkord auf Zug Innen
                    wt = innenZugList1[index]['wert']
                    kz = innenZugList1[index]['kreuz']
                    richtung = 'Z'
                elif oZZ == 'ZZ':                                              # Akkord auf Reihe-F (ganz innen)
                    wt = giZugList1[index]['wert']
                    kz = giZugList1[index]['kreuz']
                    richtung = 'Z'
                elif oZM == 'ZM':                                              # Akkord auf Zug Mitte
                    wt = mitteZugList1[index]['wert']
                    kz = mitteZugList1[index]['kreuz']
                    richtung = 'Z'          
                elif innenZugList1.has_key(index):                             # Kreuzgriff Zug Innen         
                    wt = innenZugList1[index]['wert']
                    kz = innenZugList1[index]['kreuz']
                    richtung = 'Z'
                elif giZugList1.has_key(index):                                # Kreuzgriff Reihe-F (ganz innen)        
                    wt = giZugList1[index]['wert']
                    kz = giZugList1[index]['kreuz']
                    richtung = 'Z'
                elif mitteZugList1.has_key(index):                             # Kreuzgriff Zug Mitte         
                    wt = mitteZugList1[index]['wert']
                    kz = mitteZugList1[index]['kreuz']
                    richtung = 'Z'
                elif aussenZugList1.has_key(index):                            # Kreuzgriff Zug Aussen         
                    wt = aussenZugList1[index]['wert']
                    kz = aussenZugList1[index]['kreuz']
                    richtung = 'Z'
                else:
                    wt = 'XX'                                                  # Ton nicht auf Zug
                    kz = 'XX'
                    richtung = 'X'

            if direction == 'M':                                               # bevorzugt Mitte
                if oZM == 'ZM':                                                # Akkord auf Zug Mitte
                    wt = mitteZugList1[index]['wert']
                    kz = mitteZugList1[index]['kreuz']
                    richtung = 'Z'
                elif oZI == 'ZI':                                              # Akkord auf Zug Innen
                    wt = innenZugList1[index]['wert']
                    kz = innenZugList1[index]['kreuz']
                    richtung = 'Z'
                elif oZA == 'ZA':                                              # Akkord auf Zug Aussen
                    wt = aussenZugList1[index]['wert']
                    kz = aussenZugList1[index]['kreuz']
                    richtung = 'Z'
                elif mitteZugList1.has_key(index):                             # Kreuzgriff Zug Mitte         
                    wt = mitteZugList1[index]['wert']
                    kz = mitteZugList1[index]['kreuz']
                    richtung = 'Z'
                elif innenZugList1.has_key(index):                             # Kreuzgriff Zug Innen         
                    wt = innenZugList1[index]['wert']
                    kz = innenZugList1[index]['kreuz']
                    richtung = 'Z'
                elif aussenZugList1.has_key(index):                            # Kreuzgriff Zug Aussen         
                    wt = aussenZugList1[index]['wert']
                    kz = aussenZugList1[index]['kreuz']
                    richtung = 'Z'  
                elif giZugList1.has_key(index):                                # Kreuzgriff Reihe-F  (ganz innen)       
                    wt = giZugList1[index]['wert']
                    kz = giZugList1[index]['kreuz']
                    richtung = 'Z'
                else:
                    wt = 'XX'                                                  # Ton nicht auf Zug
                    kz = 'XX'
                    richtung = 'X'

            if direction == 'A':                                               # bevorzugt Aussen
                if oZA == 'ZA':                                                # Akkord auf Zug Aussen
                    wt = aussenZugList1[index]['wert']
                    kz = aussenZugList1[index]['kreuz']
                    richtung = 'Z'
                elif oZM == 'ZM':                                              # Akkord auf Zug Mitte
                    wt = mitteZugList1[index]['wert']
                    kz = mitteZugList1[index]['kreuz']
                    richtung = 'Z'
                elif oZI == 'ZI':                                              # Akkord auf Zug Innen
                    wt = innenZugList1[index]['wert']
                    kz = innenZugList1[index]['kreuz']
                    richtung = 'Z'
                elif aussenZugList1.has_key(index):                            # Kreuzgriff Zug Aussen         
                    wt = aussenZugList1[index]['wert']
                    kz = aussenZugList1[index]['kreuz']
                    richtung = 'Z'                 
                elif mitteZugList1.has_key(index):                             # Kreuzgriff Zug Mitte         
                    wt = mitteZugList1[index]['wert']
                    kz = mitteZugList1[index]['kreuz']
                    richtung = 'Z'   
                elif innenZugList1.has_key(index):                             # Kreuzgriff Zug Innen         
                    wt = innenZugList1[index]['wert']
                    kz = innenZugList1[index]['kreuz']
                    richtung = 'Z'
                elif giZugList1.has_key(index):                                # Kreuzgriff Reihe-F  (ganz innen)       
                    wt = giZugList1[index]['wert']
                    kz = giZugList1[index]['kreuz']
                    richtung = 'Z'
                else:
                    wt = 'XX'                                                  # Ton nicht auf Zug
                    kz = 'XX'
                    richtung = 'X'

            if direction == 'Z':                                               # bevorzugt ganz innen
                if oZZ == 'ZZ':                                                # Akkord auf Reihe-F (ganz innen)
                    wt = giZugList1[index]['wert']
                    kz = giZugList1[index]['kreuz']
                    richtung = 'Z'
                elif giZugList1.has_key(index):                                # Kreuzgriff Reihe-F (ganz innen)        
                    wt = giZugList1[index]['wert']
                    kz = giZugList1[index]['kreuz']
                    richtung = 'Z'
                elif innenZugList1.has_key(index):                             # Kreuzgriff Zug Innen         
                    wt = innenZugList1[index]['wert']
                    kz = innenZugList1[index]['kreuz']
                    richtung = 'Z'
                elif mitteZugList1.has_key(index):                             # Kreuzgriff Zug Mitte         
                    wt = mitteZugList1[index]['wert']
                    kz = mitteZugList1[index]['kreuz']
                    richtung = 'Z'
                elif aussenZugList1.has_key(index):                            # Kreuzgriff Zug Aussen         
                    wt = aussenZugList1[index]['wert']
                    kz = aussenZugList1[index]['kreuz']
                    richtung = 'Z'
                else:
                    wt = 'XX'                                                  # Ton nicht auf Zug
                    kz = 'XX'
                    richtung = 'X'
        else:
            wt = 'XX'                                                          # Ton nicht auf dem Instrument
            kz = 'XX'
            richtung = 'X'

        #messageBox('TON',str(wt) + '  ' + str(kz))
        
        if richtung <> 'X':
            insertHead(head,hd,wt,kz,chord,score)                              # Kopf einfgen
        else:        
            if lHvalid == 0:
                lH      = len(head)
                lHvalid = 1
            #messageBox('Start',str(lH) + '  ' + str(hd))
            if darNicht == 1:                                                  # wenn rot frben
                new = addElementNode(head[hd].parentNode.parentNode,'display') # Original Note anzeigen und
                new.setAttribute('color',str('E00050'))                        # rot einfrben

            elif darNicht == 0 and lH > 1:                                     # wenn entfernen
                x = head[hd].parentNode.removeChild(head[hd])                  # Kopf entfernen
                lH = lH - 1
                #messageBox('Kopf entfernt',str(len(head)) + '  ' + str(hd))
            
            elif darNicht == 0 and lH == 1:                                    # ausser wenn letzter
                #messageBox('ROT','rot frben')
                new = addElementNode(head[hd].parentNode.parentNode,'display') # Original Note anzeigen und
                new.setAttribute('color',str('E00050'))                        # rot einfrben
                       
        #messageBox('Richtung',str(richtung ))

        if richtung == 'D':                                                    # wenn Druck, dann Balken anzeigen
            dObjs = chord.getElementsByTagName('drawObjects')
            if dObjs.length == 0:                                              # falls noch keine drawObjects da sind
                new = addElementNode(head[hd].parentNode.parentNode,'drawObjects')
                dO  = addElementNode(new,'drawObj')
            else:
                dO = doc.createElement('drawObj')                              # falls bereits drawObjects vorhanden sind
                dObjs[0].appendChild(dO)
 
            line = addElementNode(dO,'line')
            y1 = 10.875 - 8 + float(tzlOben) + float(tzlUnten)
            line.setAttribute('x1','-0.5')
            line.setAttribute('x2','0.5')
            line.setAttribute('y1',str(y1))
            line.setAttribute('y2',str(y1))
            line.setAttribute('lineWidth','0.5')

    for hd in range(head.length):                                              # eventuelle Vorzeichen in Tabulatur unterdrcken 
        altsup = addElementNode(head[hd],'alter')
        altsup.setAttribute('display','suppress' )

    return

def transposeOct(score):                                        # nach Wunsch oktavieren
    global oktInnen, oktMitte, oktAussen, oktGi
    key = '0'
    systems = score.getElementsByTagName('system')
    for sy in range(systems.length):
        staves = systems[sy].getElementsByTagName('staff')
        for st in range(staves.length):
            voices = staves[st].getElementsByTagName('voice')
            for vo in range(voices.length):
                noteObjects = getElementObjects(voices[vo].getElementsByTagName('noteObjects')[0].childNodes)
                for ob in range(noteObjects.length):            # Anzahl Note Objects in der Zeile
                    nv = noteObjects[ob].nodeName
                    if nv == 'keySign':
                        key = noteObjects[ob].getAttribute('fifths')                        
                    elif nv == 'chord':
                        heads = getElementObjects(noteObjects[ob].getElementsByTagName('heads')[0].childNodes)
                        for hd in range(heads.length):
                            head  = heads[hd].getAttribute('pitch')
 
                            if key == '0' and str(oktGi) == '4':
                                lage  = int(head[1])-2
                            elif key == '0' and str(oktGi) == '3':
                                lage  = int(head[1])-1
                            elif key == '0' and str(oktGi) == '2':
                                lage  = int(head[1]) 
                            elif key == '0' and str(oktGi) == '1':
                                lage  = int(head[1])+1
                            elif key == '0' and str(oktGi) == '0':
                                lage  = int(head[1])+2
                            if key == '1' and str(oktInnen) == '4':
                                lage  = int(head[1])-2
                            elif key == '1' and str(oktInnen) == '3':
                                lage  = int(head[1])-1
                            elif key == '1' and str(oktInnen) == '2':
                                lage  = int(head[1]) 
                            elif key == '1' and str(oktInnen) == '1':
                                lage  = int(head[1])+1
                            elif key == '1' and str(oktInnen) == '0':
                                lage  = int(head[1])+2
                            elif key == '2' and str(oktMitte) == '4':
                                lage  = int(head[1])-2
                            elif key == '2' and str(oktMitte) == '3':
                                lage  = int(head[1])-1    
                            elif key == '2' and str(oktMitte) == '2':
                                lage  = int(head[1])
                            elif key == '2' and str(oktMitte) == '1':
                                lage  = int(head[1])+1
                            elif key == '2' and str(oktMitte) == '0':
                                lage  = int(head[1])+2
                            elif key == '3' and str(oktAussen) == '4':
                                lage  = int(head[1])-2
                            elif key == '3' and str(oktAussen) == '3':
                                lage  = int(head[1])-1
                            elif key == '3' and str(oktAussen) == '2':
                                lage  = int(head[1])
                            elif key == '3' and str(oktAussen) == '1':
                                lage  = int(head[1])+1
                            elif key == '3' and str(oktAussen) == '0':
                                lage  = int(head[1])+2
                            elif key == '4' and str(oktGi)     == '4':
                                lage  = int(head[1])-2
                            elif key == '4' and str(oktGi)     == '3':
                                lage  = int(head[1])-1
                            elif key == '4' and str(oktGi)     == '2':
                                lage  = int(head[1])
                            elif key == '4' and str(oktGi)     == '1':
                                lage  = int(head[1])+1
                            elif key == '4' and str(oktGi)     == '0':
                                lage  = int(head[1])+2
                            lageNeu = head[0:1] + str(lage)
                            heads[hd].setAttribute('pitch',str(lageNeu))
    return

def insertTimeSign(score, zeile, time):                       # zur besseren Formatierung Takt bernehmen
    sys     = score.getElementsByTagName('system')
    staves  = sys[zeile].getElementsByTagName('staves')
    staff1  = staves[0].getElementsByTagName('staff')
    voices1 = staff1[1].getElementsByTagName('voices')
    voice1  = voices1[0].getElementsByTagName('voice')         # Tabulatur Zeile
    voices2 = staff1[2].getElementsByTagName('voices')
    voice2  = voices2[0].getElementsByTagName('voice')         # Begleitungs Zeile
    no = voice2[0].getElementsByTagName('noteObjects')
    el = addNewElementNode(no[0],'timeSign')
    el.setAttribute('time',time)
    el.setAttribute('color','FFFFFF')
    
def insertPlaceholder(score, zeile, taktsumme, type):
    global darPlatz

    sys     = score.getElementsByTagName('system')
    staves  = sys[zeile].getElementsByTagName('staves')
    staff1  = staves[0].getElementsByTagName('staff')
    voices1 = staff1[1].getElementsByTagName('voices')
    voice1  = voices1[0].getElementsByTagName('voice')         # Tabulatur Zeile
    voices2 = staff1[2].getElementsByTagName('voices')
    voice2  = voices2[0].getElementsByTagName('voice')         # Begleitungs Zeile
    taktsumme = taktsumme * 4
    tw = divmod(float(taktsumme),1)
    cnt1 = tw[0]                                               # Anzahl 4tel bis Taktstrich
    cnt2 = tw[1]                                               # unvollstndige Takte
    #messageBox('Anzahl',str(cnt1) + '    ' + str(cnt2))

    if cnt2 > 0:
        #messageBox('ungerade',str(cnt2))
        no = voice2[0].getElementsByTagName('noteObjects')
        el = addNewElementNode(no[0],'chord')
        du = addNewElementNode(el,'duration')
        di = addNewElementNode(el,'display')
        if cnt2 >= 0.5:
            du.setAttribute('base','1/8')
            cnt2 = cnt2 - 0.5
        else:
            du.setAttribute('base','1/16')
            cnt2 = cnt2 - 0.25
        if cnt2 <> 0:
            du.setAttribute('dots','1')
        di.setAttribute('invisible','true')
                                
    if str(darPlatz) == '1':                                   # Anzahl Noten verdoppeln wenn 1/8 als Platzhalter 
        notenlg = '1/8'
        cnt1    = cnt1 * 2
    else:
        notenlg = '1/4'
                            
    while cnt1 <> 0:                                           # Anzahl Noten bis Taktstrich auflsen
        no = voice2[0].getElementsByTagName('noteObjects')
        el = addNewElementNode(no[0],'chord')
        du = addNewElementNode(el,'duration')
        di = addNewElementNode(el,'display')
        du.setAttribute('base',notenlg)
        di.setAttribute('invisible','true')
        cnt1 = cnt1 - 1

    if type == 1:                                              # explicite Barline bernehmen
        no = voice2[0].getElementsByTagName('noteObjects')
        el = addNewElementNode(no[0],'barline')
        #messageBox('Barline',str(no) + '\n' + str(el))

    return

def changeDoc(score):
    global doc, nzlAnz, saOben, saZw, nzlOben, nzlUnten, tzlOben, tzlUnten, tzlSg, dCnt, zCnt, aDir, time
    global lzlAbstand, lzlStrophe, oktInnen, oktMitte, oktAussen, darNicht, darKopf, darInst, summe, notenWert
    global aDir

    #messageBox('ChangeDoc','start')

    doc    = score.parentNode

    for system in score.getElementsByTagName('system'):               # falls am Zeilenende eine Pause oder 
        for nOs in system.getElementsByTagName('noteObjects'):        # Note steht, sicherheitshalber einen  
            cn = nOs.childNodes                                       # festen Taktstrich einsteuern
            lc = len(cn)
            ln = str(cn[lc-2])
            if ln.find('chord') >= 0 or ln.find('rest') >= 0:          # festen Taktstrich dranhngen
                #messageBox('offen','barline')
                el = addNewElementNode(nOs,'barline')
                #el.setAttribute('type','double')
    
    ssIx = 0                                                           # Leerzeilen merken   
    savesystem =  []
    for system in score.getElementsByTagName('system'):
        for nOs in system.getElementsByTagName('noteObjects'):
            emptyVoice = 0  
            for no in nOs.getElementsByTagName('chord'):
                emptyVoice = 1
            for rs in nOs.getElementsByTagName('rest'):
                emptyVoice = 1
            if emptyVoice == 0:
                savesystem.append(system)
                ssIx = ssIx + 1

    layout = score.getElementsByTagName('layout')                      # Layout erweitern
    staves = layout[0].getElementsByTagName('staves')
    slEl   = staves[0].getElementsByTagName('staffLayout')
    slNd   = slEl[0].cloneNode('staffLayout')                          # Notenzeile als Tabularturzeile clonen
    staves[0].appendChild(slNd)
    slNd.setAttribute('description','Tabulatur')                
    slNd   = slEl[0].cloneNode('staffLayout')                          # Notenzeile als Akkord / Spielanweisungszeile clonen
    staves[0].appendChild(slNd)
    slNd.setAttribute('description','Begleitung')
    riTAB  = staves[0].lastChild
    notation = riTAB.getElementsByTagName('notation')
    notation[0].setAttribute('defaultClef','N3')                       # Schlssel weg
    notation[0].setAttribute('notelines','________')                   # klassisch : keine Line
    barLines = riTAB.getElementsByTagName('barlines')
    barLines[0].setAttribute('from','2')
    barLines[0].setAttribute('to','2')

    layout  = score.getElementsByTagName('layout')                     # Systemabstnde setzen
    systems = layout[0].getElementsByTagName('systems')
    systems[0].setAttribute('top',str(saOben))
    systems[0].setAttribute('between',str(saZw))
    staves = layout[0].getElementsByTagName('staves')
    n = 1
    for sL in staves[0].getElementsByTagName('staffLayout'):           
        distances = sL.getElementsByTagName('distances')
        if n == 1:
            distances[0].setAttribute('top',str(nzlOben))              # Notenzeilen Abstnde setzen
            distances[0].setAttribute('bottom',str(nzlUnten))
            n = n + 1
        else:
            distances[0].setAttribute('top',str(tzlOben))              # Tabulatur Abstnde setzen
            distances[0].setAttribute('bottom',str(tzlUnten))
            n = n + 1
            
    for lZ in score.getElementsByTagName('lyricsSettings'):            # Lyrics Abstnde setzen
            lza = float(lzlAbstand)/2
            lsa = float(lzlStrophe)/2
            lZ.setAttribute('firstLine',str(lza))                   
            lZ.setAttribute('lineDist',str(lsa))

    for system in score.getElementsByTagName('system'):                # Notenzeile laut Layout einfgen
        staff = system.getElementsByTagName('staff')[0]
        for extraDist in staff.getElementsByTagName('extraDistance'):  # zustzlicher Abstand weg
            extraDist.parentNode.removeChild(extraDist)
        if nzlLt == 1:                                                 # wenn gewnscht 
            for lyric in staff.getElementsByTagName('lyric'):          # Lyric aus Tabulatur entfernen 05.12.05
                lyric.parentNode.removeChild(lyric)
        newStaff = staff.cloneNode(True)
        newStaff.setAttribute('layout','Tabulatur')
        newStaff = staff.parentNode.appendChild(newStaff)
        for clefSign in newStaff.getElementsByTagName('clefSign'):     # Schlssel weg
            clefSign.setAttribute('clef','N3')
        for keySign in newStaff.getElementsByTagName('keySign'):       # Tonart weg
            keySign.parentNode.removeChild(keySign)
        newStaff = staff.cloneNode(True)
        newStaff.setAttribute('layout','Begleitung')
        newStaff = staff.parentNode.appendChild(newStaff)              # Spielzeile einfgen     
        for clefSign in newStaff.getElementsByTagName('clefSign'):     # Schlssel weg 
            clefSign.setAttribute('clef','N3')
        for chord in newStaff.getElementsByTagName('chord'):           # Noten weg
            chord.parentNode.removeChild(chord)
        for rest in newStaff.getElementsByTagName('rest'):             # Pausen weg
            rest.parentNode.removeChild(rest)            
        for keySign in newStaff.getElementsByTagName('keySign'):       # Tonart weg
            keySign.parentNode.removeChild(keySign)
        for barLine in newStaff.getElementsByTagName('barline'):       # Taktstriche weg
            barLine.parentNode.removeChild(barLine)
        for timeSign in newStaff.getElementsByTagName('timeSign'):     # Takt weg     13.10.05
            timeSign.parentNode.removeChild(timeSign)
        for lyric in staff.getElementsByTagName('lyric'):              # Lyric aus Melodiestimme entfernen 05.12.05
            lyric.parentNode.removeChild(lyric)

    taktsumme = 0                                                      # Begleitstimme vorbereiten durch 

    #messageBox('ChangeDoc','vor Begleitstimme vorbereiten')   
                                                                       # einsetzen von Platzhaltern
    for sy in range(activeScore().nSystems()):
        System = activeScore().system(sy)
        #messageBox('KEY',str(taktsumme))
        if taktsumme <> 0:                                             # offene Zeilenenden 
            #messageBox('SAVE',str(taktsumme))
            type = 0
            #messageBox('KEY',"Taktsumme <> 0")
            insertPlaceholder(score,sySave,taktsumme,type)
            taktsumme = 0
        #messageBox('ST',str(range(System.nStaves())))
        zeilenanfang = 1
        for st in range(System.nStaves()):
            sySave = sy
            Staff = System.staff(st)
            for vo in range(Staff.nVoices()):
                Voice = Staff.voice(vo)
                #messageBox('KEY',str(taktsumme))
               
                for no in range(Voice.nNoteObjs()):
                    NoteObj = Voice.noteObj(no)
                    #messageBox('KEY',str(NoteObj.subType()))
                    #messageBox('KEY',str(taktsumme))
                    if NoteObj.isRest():
                        zeilenanfang = 0
                        lg = NoteObj.duration()
                        taktsumme = taktsumme + lg
                    elif NoteObj.isChord():
                        zeilenanfang = 0
                        lg = NoteObj.duration()
                        taktsumme = taktsumme + lg
                    elif NoteObj.isBarline() and zeilenanfang == 0:
                        type = 1
                        #messageBox('KEY',"isBarline")
                        insertPlaceholder(score,sy,taktsumme,type)
                        taktsumme = 0
                    if NoteObj.implBarline() and zeilenanfang == 0:
                        type = 1
                        #messageBox('KEY',"implicitBarline")
                        insertPlaceholder(score,sy,taktsumme,type)
                        taktsumme = 0
                    if NoteObj.meter() and zeilenanfang == 0:
                        type = 0
                        time = str(NoteObj.meter())
                        if time == '1': time = '4/4'
                        #messageBox('KEY',str(time))
                        insertPlaceholder(score,sy,taktsumme,type)  
                        insertTimeSign(score,sy,time)                        
                        taktsumme = 0
                    if NoteObj.subType() == 3 and zeilenanfang == 0:   # Tonart  9.4.2008
                        type = 1
                        #messageBox('KEY',"Tonart")
                        insertPlaceholder(score,sy,taktsumme,type)      
                        taktsumme = 0
                if taktsumme <> 0:                                     # wenn noch Reste durch einen offenen Takt am Ende sind, Platzhalter erstellen. 10.3.2012 
                    #messageBox('KEY',str(taktsumme))
                    type = 1
                    insertPlaceholder(score,sy,taktsumme,type)
                    
    #messageBox('ChangeDoc','vor in Griffschrift umwandeln')

    system = score.getElementsByTagName('system')                      # In Griffschrift umwandeln
    aDir = 'N'                                                         # Voreinstellung - not defined
    #dr   = 'M'                                                         # Voreinstellung - Richtung 
    for sy in range(system.length):
        staff = system[sy].getElementsByTagName('staff')               # Notenzeile extrahieren
        for st in range(staff.length):
            if str(staff[st].getAttribute('layout')) == 'Tabulatur':
                voices = staff[st].getElementsByTagName('voice')       
                voice = voices[0]                                      # Tabulaturstimme extrahieren
                noteObjects = voices[0].getElementsByTagName('noteObjects')
                chords = noteObjects[0].childNodes                     # Noten und Pausen extrahieren
                
                basic = voices[0].getElementsByTagName('basic')        # ersten verfgbaren Akkord finden 
                for ba in range(basic.length):                         # um Reihe fr Auftakt ohne Akkord 
                        if basic[ba].hasAttribute('tag'):              # festzulegen
                            tag = basic[ba].getAttribute('tag')
                            if tag == '2086-31' or tag == '2086-32' or tag == '2086-33' or tag == '2086-34' or tag == '2086-41' or tag == '2086-42' or tag == '2086-43' or tag == '2086-44':
                                dr = str(tag[6])                            
                                if dr == '1': dr = 'I'
                                if dr == '2': dr = 'M'
                                if dr == '3': dr = 'A'
                                if dr == '4': dr = 'Z'
                                break

                for ch in range(chords.length):
                    if chords[ch].nodeType <> chords[ch].ELEMENT_NODE:
                        continue
                    else:
                        if chords[ch].tagName <> 'chord' and chords[ch].tagName <> 'rest':
                            continue
                    basic = chords[ch].getElementsByTagName('basic')   # Feststellung ob Druck oder Zug
                    for ba in range(basic.length):                     # abhngig von Begleitakkord
                        if basic[ba].hasAttribute('tag'):
                            tag = basic[ba].getAttribute('tag')
                            if tag == '2086-31' or tag == '2086-32' or tag == '2086-33' or tag == '2086-34':
                                aDir = 'D'
                            if tag == '2086-41' or tag == '2086-42' or tag == '2086-43' or tag == '2086-44':
                                aDir = 'Z'
                            if tag == '2086-50' or tag == '2086-51' or tag == '2086-52' or tag == '2086-53':   # ignoriere Akkorde und ID
                                a=1
                            else:
                                text = basic[ba].parentNode.getElementsByTagName('content')
                                bass = text[0].firstChild.data             # Akkord + Reihe extrahieren
                                dr = str(tag[6])                           # bevorzugte Reihe extrahieren I/M/A
                                if dr == '1': dr = 'I'
                                if dr == '2': dr = 'M'
                                if dr == '3': dr = 'A'
                                if dr == '4': dr = 'Z'
                                taste = bass
                                content = score.parentNode.createElement('content')
                                content.appendChild(score.parentNode.createTextNode(taste))
                                text[0].appendChild(content)               # und setzen
                                text = basic[ba].parentNode.getElementsByTagName('text')
                                accPos = (((float(tzlUnten) + float(tzlOben))/2)*2)+2  # Position des Begleitakkords ber der Druck-Linie
                                text[0].setAttribute('y',str(accPos))
                                text[0].setAttribute('x','-0.5')
                                text = basic[ba].parentNode.getElementsByTagName('font')
                                text[0].setAttribute('face','Times New Roman')
                                text[0].setAttribute('height',str(tzlSg))                          
                                text[0].setAttribute('weight','0')
                                text[0].setAttribute('pitchAndFamily','0')
                            
                    if chords[ch].tagName == 'chord':
                        #messageBox('darInst',str(darInst))
                        firstNote = 0
                        heads = chords[ch].getElementsByTagName('heads')
                        head  = heads[0].getElementsByTagName('head')          # Kpfe pro Note extrahieren
                        if darInst == 0:
                            analyseHeads1(score,head,chords[ch],dr)            # und umwandeln 3-Reiher
                        else:    
                            analyseHeads2(score,head,chords[ch],dr)            # und umwandeln 4-Reiher

                    if chords[ch].tagName == 'rest':
                        if aDir == 'D':                                        # wenn Druck, dann Balken anzeigen
                            dObjs = chords[ch].getElementsByTagName('drawObjects')
                            if dObjs.length == 0:                              # falls noch keine drawObjects da sind
                                new = addElementNode(chords[ch],'drawObjects')
                                dO  = addElementNode(new,'drawObj')
                            else:
                                dO = doc.createElement('drawObj')              # falls bereits drawObjects vorhanden sind
                                dObjs[0].appendChild(dO)
 
                            line = addElementNode(dO,'line')
                            y1 = 10.875 - 8 + float(tzlOben) + float(tzlUnten)
                            line.setAttribute('x1','-0.5')
                            line.setAttribute('x2','0.5')
                            line.setAttribute('y1',str(y1))
                            line.setAttribute('y2',str(y1))
                            line.setAttribute('lineWidth','0.5')
                            
    ProcessExceptionList(score)                                                # Alternative Griffe suchen
    
    dos = score.getElementsByTagName('drawObj')                                # Bindebogen anpassen  
    for do in range(dos.length):
        slur = dos[do].getElementsByTagName('slur')
        for sl in range(slur.length):
            basics = slur[sl].parentNode.parentNode.parentNode.getElementsByTagName('basic')
            for ba in range(basics.length):
                if basics[ba].hasAttribute('noAdjust'):
                    basics[ba].removeAttribute('noAdjust')
            slur[sl].removeAttribute('x1')
            slur[sl].removeAttribute('x2')
            slur[sl].removeAttribute('x3')
            slur[sl].removeAttribute('x4')
            slur[sl].removeAttribute('y1')
            slur[sl].removeAttribute('y2')
            slur[sl].removeAttribute('y3')
            slur[sl].removeAttribute('y4')
        
    #messageBox('ChangeDoc','Vor aufrumen')
    systems = score.getElementsByTagName('systems')
    if nzlAnz == 1:                                                    # Notenzeile lschen
        for sys in systems[1].getElementsByTagName('system'):          # wenn im Dialog ausgewhlt
            staves = sys.getElementsByTagName('staves')
            staff  = staves[0].getElementsByTagName('staff')
            staff[0].parentNode.removeChild(staff[0])
            
        lay  = score.getElementsByTagName('layout')                    # Notenzeile aus 
        for sv in lay[0].getElementsByTagName('staves'):               # Partiturschablone
            sl  = sv.getElementsByTagName('staffLayout')               # entfernen
            sl[0].parentNode.removeChild(sl[0])
            break

    if ssIx <> 0:                                                      # Leerzeilen entfernen
        for i in range(ssIx):
            savesystem[i].parentNode.removeChild(savesystem[i])
            
    return

    
def pqDialog():
    global nzlAnz, saOben, saZw, nzlOben, nzlUnten, tzlOben, tzlUnten, tzlSg, lzlAbstand, lzlStrophe
    global oktGi, oktInnen, oktMitte, oktAussen, darNicht, darKopf, darPlatz, darInst, darAuftakt, darSize
    global nzlLt, exZug, exDruck, version
    
    vorbereitet = 'NO'                          # prfen ob bereits mit "Ziach_A" vorbereitet
    for no in activeScore().noteObjs():         # und BassId laden
        if no.isChord() or no.isRest():
            i = no.nDrawObjs()-1
            while i >= 0:
                d = no.drawObj(i)
                if d.has_key('tag'):
                    xx = d['tag']
                    if xx == '2086-51':
                        vorbereitet = 'OK'
                        bassId = d['content']
                        if bassId < '11':darInst=1
                        else:darInst=0
                        break
                    else:
                        i -= 1
                else:
                    i -= 1
    if vorbereitet == 'NO':
        messageBox('Ziach_B',tr('msgB01'))
        return False
    
                 
    options = ScriptOptions() 
    opt = options.get()
    #messageBox('Options',str(opt))
    # Dialog Defaults
    
    lt = '0'                # Liedtext anzeigen
    na = '1'                # Notenzeile anzeigen
    so = '15'               # Systemabstand ber erstem System
    su = '8'                # Systemabstand zwischen den Systemen
    no = '4'                # Notenzeile Abstand nach oben 
    nu = '10'               # Notenzeile Abstand nach unten
    to = '3'                # Tabulatur Abstand nach oben
    tu = '4'                # Tabulatur Abstand nach unten
    ts = '14'               # Schriftgre Tabulatur
    la = '25'               # Liedzeile Abstand zur Mittellinie
    ls = '5'                # Liedstrophen Abstand
    og = '2'                # Oktavierung ganz innen
    oi = '2'                # Oktavierung innen
    om = '2'                # Oktavierung mitte
    oa = '2'                # Oktavierung aussen
    dz = '0'                # nichtdarstellbare Noten 0=unterdrcken, 1=rot
    dk = '0'                # Kopfform  0=klassisch, 1=alternativ
    dp = '0'                # Platzhalter fr Begleitstimme  0=Viertelnoten, 1=Achtelnoten
    da = '0'                # Auftakt ohne Akkord  0=Druck, 1=Zug
    ez = '1'
    ed = '1'
    ds = '18'               # Gre des Kreuzes bei alternativer Darstellung
    
    if opt:
        lt = opt.get('dNzlLt',lt)
        na = opt.get('dNzlAnz',na)
        so = opt.get('dSaOben',so)
        su = opt.get('dSaZw',su)
        no = opt.get('dNzlOben',no)
        nu = opt.get('dNzlUnten',nu)
        to = opt.get('dTzlOben',to)
        tu = opt.get('dTzlUnten',tu)
        ts = opt.get('dTzlSg',ts)
        la = opt.get('dLzlAbstand',la)
        ls = opt.get('dLzlStrophe',ls)
        og = opt.get('dOktGi',og)
        oi = opt.get('dOktInnen',oi)
        om = opt.get('dOktMitte',om)
        oa = opt.get('dOktAussen',oa)
        dz = opt.get('dDarNicht',dz)
        dk = opt.get('dDarKopf',dk)
        dp = opt.get('dDarPlatz',dp)
        da = opt.get('dDarAuftakt',da)
        ez = opt.get('dexZug',ez)
        ed = opt.get('dexDruck',ed)
        ds = opt.get('dDarSize',ds)

    placeholder1   = Label('       ',width=1)
    placeholder2   = Label('     ',width=1)
    placeholder3   = Label('   ',width=1)
    placeholder4   = Label(' ',width=1)
  
    radNzlAnz      = Radio([tr('msgB02'),tr('msgB03')],text=tr('msgB04'),value=int(opt.get('nzlAnz',str(na))))
    radDarN        = Radio([tr('msgB05'),tr('msgB06')],text=tr('msgB07'),value=int(opt.get('darNicht',str(dz))))
    radDarK        = Radio([tr('msgB08'),tr('msgB09')],text=tr('msgB10'),value=int(opt.get('darKopf',str(dk))))
    radDarP        = Radio([tr('msgB11'),tr('msgB12')],text=tr('msgB13'),value=int(opt.get('darPlatz',str(dp))))
    radDarAuftakt  = Radio([tr('msgB14'),tr('msgB15')],text=tr('msgB16'),value=int(opt.get('darAuftakt',str(da))))
    editDarSize    = Edit (opt.get('darSize',str(ds)),width=3)
    subboxSz       = HBox([editDarSize,placeholder1,placeholder1,placeholder1,placeholder1,placeholder1,placeholder1,placeholder1,placeholder1])
    subboxSize     = VBox([subboxSz],text=tr('msgB44'))
    subboxDar      = HBox([radNzlAnz,radDarN,radDarK,subboxSize,placeholder1],padding=4)
    box1           = HBox([subboxDar,placeholder4],padding=4)
    mainboxDar     = VBox([box1],text=tr('msgB17'))
    
    radOktG        = Radio([tr('msgB18'),tr('msgB19'),tr('msgB20'),tr('msgB21'),tr('msgB22')],text=tr('msgB23'),value=int(opt.get('oktGi',str(og))))
    radOktI        = Radio([tr('msgB18'),tr('msgB19'),tr('msgB20'),tr('msgB21'),tr('msgB22')],text=tr('msgB24'),value=int(opt.get('oktInnen',str(oi))))
    radOktM        = Radio([tr('msgB18'),tr('msgB19'),tr('msgB20'),tr('msgB21'),tr('msgB22')],text=tr('msgB25'),value=int(opt.get('oktMitte',str(om))))
    radOktA        = Radio([tr('msgB18'),tr('msgB19'),tr('msgB20'),tr('msgB21'),tr('msgB22')],text=tr('msgB26'),value=int(opt.get('oktAussen',str(oa))))
    subboxOkt      = HBox([radOktA,radOktM,radOktI,radOktG,placeholder2],padding=4)
    mainboxOkt     = VBox([subboxOkt],text=tr('msgB27'))
 
    lablSaOben     = Label(tr('msgB28'),width=6)                                   # Systemabstnde
    editSaOben     = Edit (opt.get('saOben',str(so)),width=5)
    lablSaZw       = Label(tr('msgB29'),width=6)
    editSaZw       = Edit (opt.get('saZw',str(su)),width=5)
    subboxSaOben   = HBox([lablSaOben,editSaOben,placeholder4],padding=0)
    subboxSaZw     = HBox([lablSaZw,editSaZw,placeholder4],padding=0)
    box1           = VBox([subboxSaOben,subboxSaZw,placeholder4],padding=4)
    mainboxSa      = VBox([box1],text=tr('msgB30'))

    lablNzlOben    = Label(tr('msgB31'),width=6)                                   # Notenzeile
    editNzlOben    = Edit (opt.get('nzlOben',str(no)),width=5)
    lablNzlUnten   = Label(tr('msgB32'),width=10)
    editNzlUnten   = Edit (opt.get('nzlUnten',str(nu)),width=5)
    subboxNzlOben  = HBox([lablNzlOben,editNzlOben,placeholder4],padding=0)
    subboxNzlUnten = HBox([lablNzlUnten,editNzlUnten,placeholder4],padding=0)
    box1           = VBox([subboxNzlOben,subboxNzlUnten,placeholder4],padding=4)
    mainboxNzl     = VBox([box1],text=tr('msgB37'))
    
    lablTzlOben    = Label(tr('msgB31'),width=6)                                  # Griffschrift
    editTzlOben    = Edit (opt.get('tzlOben',str(to)),width=5)
    lablTzlUnten   = Label(tr('msgB32'),width=5)
    editTzlUnten   = Edit (opt.get('tzlUnten',str(tu)),width=5)
    lablTzlSg      = Label(tr('msgB38'),width=5)                                  #Schriftgre
    editTzlSg      = Edit (opt.get('tzlSg',str(ts)),width=5)
    subboxTzlOben  = HBox([lablTzlOben,editTzlOben,placeholder4],padding=0)
    subboxTzlUnten = HBox([lablTzlUnten,editTzlUnten,placeholder4],padding=0)
    subboxTzlSg    = HBox([lablTzlSg,editTzlSg,placeholder4],padding=0)
    box1           = VBox([subboxTzlOben,subboxTzlUnten,subboxTzlSg],padding=4)
    mainboxTzl     = VBox([box1],text=tr('msgB33'))
    
    radDarLt       = Radio([tr('msgB02'),tr('msgB03')],value=int(opt.get('darLt',str(lt))))
    lablLzlAbstand = Label(tr('msgB34'),width=6)
    editLzlAbstand = Edit (opt.get('lzlAbstand',str(la)),width=5)
    lablLzlStrophe = Label(tr('msgB35'),width=10)
    editLzlStrophe = Edit (opt.get('lzlStrophe',str(ls)),width=5)
    subboxLzlAbstand = HBox([lablLzlAbstand,editLzlAbstand,placeholder4],padding=0)
    subboxLzlStrophe = HBox([lablLzlStrophe,editLzlStrophe,placeholder4],padding=0)
    box1           = VBox([radDarLt,subboxLzlAbstand,subboxLzlStrophe])
    mainboxLzl     = VBox([box1],text=tr('msgB36'))

    checkExLstZ    = CheckBox(tr('msgB42'),value=int(opt.get('exZug',str(ez))))
    checkExLstD    = CheckBox(tr('msgB43'),value=int(opt.get('exDruck',str(ed))))
    subboxExL      = VBox([checkExLstZ,checkExLstD],padding=1,text=tr('msgB40'))
    mainboxOpt     = HBox([subboxExL,radDarP,radDarAuftakt,placeholder4],text=tr('msgB41'))
    
    mainboxAbs     = HBox([mainboxSa,mainboxNzl,mainboxTzl,mainboxLzl],text=tr('msgB39'))
    
    box  = VBox([mainboxDar,mainboxAbs,mainboxOpt,mainboxOkt],padding=1)
    dlg  = Dialog('Ziach_B  Version: '+ version, box)
 
    if dlg.run():
        nzlLt       = radDarLt.value()
        nzlAnz      = radNzlAnz.value()
        saOben      = editSaOben.value()
        saZw        = editSaZw.value()
        nzlOben     = editNzlOben.value()
        nzlUnten    = editNzlUnten.value()
        tzlOben     = editTzlOben.value()
        tzlUnten    = editTzlUnten.value()
        tzlSg       = editTzlSg.value()
        lzlAbstand  = editLzlAbstand.value()
        lzlStrophe  = editLzlStrophe.value()
        oktGi       = radOktG.value()
        oktInnen    = radOktI.value()
        oktMitte    = radOktM.value()
        oktAussen   = radOktA.value()
        darNicht    = radDarN.value()
        darKopf     = radDarK.value()
        darPlatz    = radDarP.value()
        darAuftakt  = radDarAuftakt.value()
        exZug       = checkExLstZ.value()
        exDruck     = checkExLstD.value()
        darSize     = editDarSize.value()
        
        lt = opt.get('dNzlLt','')
        na = opt.get('dNzlAnz','')
        so = opt.get('dSaOben','')
        su = opt.get('dSaZw','')
        no = opt.get('dNzlOben','')
        nu = opt.get('dNzlUnten','')
        to = opt.get('dTzlOben','')
        tu = opt.get('dTzlUnten','')
        ts = opt.get('dTzlSg','')
        la = opt.get('dLzlAbstand','')
        ls = opt.get('dLzlStrophe','')
        gi = opt.get('dOktGi','')
        oi = opt.get('dOktInnen','')
        om = opt.get('dOktMitte','')
        oa = opt.get('dOktAussen','')
        dz = opt.get('dDarNicht','')
        dk = opt.get('dDarKopf','')
        dp = opt.get('dDarPlatz','')
        da = opt.get('dDarAuftakt','')
        ed = opt.get('dexZug','')
        ez = opt.get('dexDruck','')
        ds = opt.get('dDarSize','')
        
        opt  = dict(
                  dNzlLt      = str(nzlLt),
                  dNzlAnz     = str(nzlAnz),
                  dSaOben     = str(saOben),
                  dSaZw       = str(saZw),
                  dNzlOben    = str(nzlOben),
                  dNzlUnten   = str(nzlUnten),
                  dTzlOben    = str(tzlOben),
                  dTzlUnten   = str(tzlUnten),
                  dTzlSg      = str(tzlSg),
                  dLzlAbstand = str(lzlAbstand),
                  dLzlStrophe = str(lzlStrophe),
                  dOktGi      = str(oktGi),
                  dOktInnen   = str(oktInnen),
                  dOktMitte   = str(oktMitte),
                  dOktAussen  = str(oktAussen),
                  dDarNicht   = str(darNicht),
                  dDarKopf    = str(darKopf),
                  dDarPlatz   = str(darPlatz),
                  dDarAuftakt = str(darAuftakt),
                  dexZug      = str(exZug),
                  dexDruck    = str(exDruck),
                  dDarSize    = str(darSize)
                 )
        options.set(opt)

        return True
    else:
        return False
                       
# Hauptprogramm:

from caplib.capDOM import ScoreChange
import tempfile, xml.dom

global tArt

tList    = []
tArt     = 'T'

activeScore().registerUndo("Ziach_B")

class ScoreChange(ScoreChange):
    
    def changeScore(self, score):
        transposeOct(score)                      # bei Bedarf oktavieren
        changeDoc(score)                         # und endlich umwandeln
        
if activeScore():
        
    if pqDialog():
        global tempInput, tempOutput
        activeScore().registerUndo("Ziach_B")
        tempInput = tempfile.mktemp('.capx')
        tempOutput = tempfile.mktemp('.capx')
        activeScore().write(tempInput)

        ScoreChange(tempInput, tempOutput)
    
        activeScore().read(tempOutput)
        os.remove(tempInput)
        os.remove(tempOutput)



