# -*- coding: ISO-8859-1 -*-
""" capellaScript -- Copyright (c) 2004-2012 Peter Becker
>>> Ziach_C : Tabulaturschrift fr Steirische Harmonika
    Umsetzen von Noten in die Tabulaturschrift fr Steirische Harmonika.
    -> Schritt 3 von 3||
    Translation of dotted notes into Griffschrift for Steirische.||
    -> Step 3 of 3||
    
    Achtung ( Attention ): |
    - Bass-Definitionen in Ziach_DEF.py|
    - Language in Ziach_tr.py||
    
    Bei Problemen bitte eine Mail an |
    (In case of problems, please email ):|peter_becker@freenet.de
<<<

History:  16.07.04 - Version 1.0            
          29.11.04 - Version 2.0 Split into 3 Modules 
          27.12.05 - Version 3.0 National Language Support
          08.05.09 - Version 4.0, .DEF und .MSG als Python Datei
          09.05.09 - Sprachauswahl
          18.10.10 - Versionsanzeige eingefgt 4.1.1
          11.11.10 - wg. Ziach_B 4.1.2
          17.03.11 - wg. Ziach_B 4.1.3
          18.11.11 - V4.1.4  wegen Ziach_A
          10.03.12 - V4.1.5  durch Ziach_B
          08.05.12 - V4.1.6  falsche Begleitauflsung im 2. Taktteil da Capella 7.1-08 schrfer kontrolliert
          06.07.12 - V4.1.7  erste Taktzahl korrekt initialisieren, Begleitung nach Taktwechsel, festem Taktstrich usw jetzt gro
          07.07.12 - V4.1.8  Fehler bei 3/4 Takt Auflsung
          08.07.12 - V4.1.9  weitere Auflsungsfehler
          09.07.12 - V4.1.10 weitere Auflsungsfehler
          10.07.12 - V4.1.11 Druckbalken Optimierung
          03.08.12 - V4.1.12 Druckbalken Optimierung
          09.08.12 - V4.1.13 Absturz bei Formatierungsoption 2
          01.08.13 - V4.1.14 wegen Ziach_A
          21.09.14 - V4.1.15 wegen Ziach_B
          26.03.15 - V4.2.0  Umstellung auf Capella Multilanguage Support
          31.07.15 - V4.2.1  Wegen Ziach_A
"""
# TAG Liste
# 2086-31 Druck - innen        Reihe C - G-Dur
# 2086-32 Druck - mitte        Reihe B - D-Dur
# 2086-33 Druck - aussen       Reihe A - A-Dur
# 2086-34 Druck - ganz innen   Reihe F - C-Dur
# 2086-41 Zug   - innen        Reihe C - G-Dur
# 2086-42 Zug   - mitte        Reihe B - D-Dur
# 2086-43 Zug   - aussen       Reihe A - A-Dur
# 2086-44 Zug   - ganz innen   Reihe F - C-Dur 
# 2086-50 Akkordbezeichnung
# 2086-51 Bass ID
# 2086-52 Instrumententyp
# 2086-53 Bassbelegung

import xml.dom, tempfile
from caplib.capDOM import ScoreChange

version = '4.2.1 - 31.7.2015'

global noteDruckStart, posDruckStart, noteDruckEnd, posDruckEnd, TsLinks, posTsLinks, TsRechts, posTsRechts

german = ("de", {    
    "msgC01"   : 'nur Bass - Grundbass',
    "msgC02"   : '3er Takt = Aaa / 4er = Takt Aaaa / 6er Takt = Aaaaaa - Grundbass',
    "msgC03"   : '3er Takt = Aaa / 4er = Takt AaAa / 6er Takt = AaaAaa - Grundbass',
    "msgC04"   : 'Formatierungsoption auswhlen ',
    "msgC05"   : 'Begleitschema',
    "msgC06"   : 'kein Tabulatur Zeichen',
    "msgC07"   : 'TAB klein',
    "msgC08"   : 'TAB gro',
    "msgC09"   : 'Tabulaturzeichen auswhlen',
    "msgC10"   : 'TabulaturZeichen',
    "msgC11"   : 'stehen lassen',
    "msgC12"   : 'komplett lschen',
    "msgC13"   : 'unter System lschen',
    "msgC14"   : 'Verbindungslinie auswhlen ',
    "msgC15"   : 'Verbindungslinie',
    "msgC16"   : 'TAB h',
    "msgC17"   : '3er Takt = Aaa / 4er Takt = Aaaa / 6er Takt = Aaaaaa - Wechselbass',
    "msgC18"   : '3er Takt = Aaa / 4er Takt = AaBa / 6er Takt = AaaBaa - Wechselbass'
    })

try:
    from Ziach_tr import translations
    translations.append(german)
    setLanguages(translations)
except:
    #messageBox('Stop','stop')
    def tr(s):
        return german[1].get(s, "???")

#-------------------------------------------------------------------
    
def isDruck(note):

    druck = 0
    for k in range(note.nDrawObjs()):
        d = note.drawObj(k)
        if d['type'] == 'line'and d['lineWidth'] == 0.5:
            druck = 1
            break
    return druck

def lineOutput():
    
    global noteDruckStart, posDruckStart, noteDruckEnd, posDruckEnd, TsLinks, posTsLinks, TsRechts, posTsRechts
    #messageBox('Ausgabe1','noteDruckStart = ' + str(noteDruckStart) + '\n' +
    #                    'posDruckStart   = ' + str(posDruckStart) + '\n' +
    #                    'noteDruckEnd    = ' + str(noteDruckEnd) + '\n' +
    #                    'posDruckEnd     = ' + str(posDruckEnd) + '\n' +
    #                    'TsLinks         = ' + str(TsLinks) + '\n' +
    #                    'posTsLinks      = ' + str(posTsLinks) + '\n' +
    #                    'TsRechts        = ' + str(TsRechts) + '\n' +
    #                    'posTsRechts     = ' + str(posTsRechts))
    
    for k in range(noteDruckStart.nDrawObjs()):

        d = noteDruckStart.drawObj(k)
        if d['type'] == 'line' and d['lineWidth'] == 0.5:
            if posTsLinks <>  'NA':
                x1 =  posTsLinks - posDruckStart
            else:
                x1 = -1
            if posTsRechts <> 'NA':
                x2 = posDruckEnd - posDruckStart + posTsRechts - posDruckEnd
            else:
                x2 = posDruckEnd - posDruckStart
            d['x1'] = x1
            d['x2'] = x2
            noteDruckStart.replaceDrawObj(k,d)
            noteDruckStart = 'NA'                                               
            posDruckStart  = 'NA'
            noteDruckEnd   = 'NA'                                             
            posDruckEnd    = 'NA'                                               
            posDruckEnd    = 'NA'
            TsLinks        = 'NA'
            posTsLinks     = 'NA'
            TsRechts       = 'NA'
            posTsRechts    = 'NA'
            break

#checkCapVersion(5,1,5)
activeScore().registerUndo("Ziach_C")

# Wechselbsse laden

wechselBass  = {}
dir, pyFile = os.path.split(sys.argv[0])
defDatei = os.path.join(dir, 'Ziach_DEF.py')
datei        = file(defDatei,'r')
lines        = datei.readlines()
daten        = [line for line in lines if line[0:2] != '#-'] # Kommentarzeilen raus
for i in range(len(daten)):                                  # Bass-Systeme einlesen

    if daten[i][0:7] == '#Reihen':                           # Instrumententyp extrahieren ( 3 oder 4-Reiher )
        instrument = daten[i][16]

    if daten[i][0:12] == '#Bass-System':                     # Bass-System extrahieren
        bass = daten[i][16:63]

    if daten[i][0:14] == '#Bass-Belegung':                   # Bass-Belegung extrahieren
        bBel = daten[i][16:63]
        
    if daten[i][0:3] == '#ID':                               # ID extrahieren
        bassID = daten[i][16:18]
        
    if daten[i][0:4] == '#FWB':                               # Wechselbass Belegung fr die F-Reihe ( C-Dur )
        F1W = daten[i][17:19] + daten[i][21:23]
        F2W = daten[i][25:27] + daten[i][29:31]
        F3W = daten[i][33:35] + daten[i][37:39]
        F4W = daten[i][41:43] + daten[i][45:47]
        F5W = daten[i][49:51] + daten[i][53:55]
        F6W = daten[i][57:59] + daten[i][61:63]
        F7W = daten[i][65:67] + daten[i][69:71]
        F8W = daten[i][73:74] + daten[i][77:79]
        F9W = daten[i][81:83] + daten[i][85:87]
        FAW = daten[i][89:91] + daten[i][93:95]
        FBW = daten[i][97:99] + daten[i][101:103]  
        
    if daten[i][0:4] == '#AWB':                               # Wechselbass Belegung fr die A-Reihe ( G-Dur )
        A1W = daten[i][17:19] + daten[i][21:23]
        A2W = daten[i][25:27] + daten[i][29:31]
        A3W = daten[i][33:35] + daten[i][37:39]
        A4W = daten[i][41:43] + daten[i][45:47]
        A5W = daten[i][49:51] + daten[i][53:55]
        A6W = daten[i][57:59] + daten[i][61:63]
        A7W = daten[i][65:67] + daten[i][69:71]
        A8W = daten[i][73:74] + daten[i][77:79]
        A9W = daten[i][81:83] + daten[i][85:87]
        AAW = daten[i][89:91] + daten[i][93:95]
        ABW = daten[i][97:99] + daten[i][101:103]

    if daten[i][0:4] == '#BWB':                               # Wechselbass Belegung fr die B-Reihe ( D-Dur )
        B1W = daten[i][17:19] + daten[i][21:23]
        B2W = daten[i][25:27] + daten[i][29:31]
        B3W = daten[i][33:35] + daten[i][37:39]
        B4W = daten[i][41:43] + daten[i][45:47]
        B5W = daten[i][49:51] + daten[i][53:55]
        B6W = daten[i][57:59] + daten[i][61:63]
        B7W = daten[i][65:67] + daten[i][69:71]
        B8W = daten[i][73:74] + daten[i][77:79]
        B9W = daten[i][81:83] + daten[i][85:87]
        BAW = daten[i][89:91] + daten[i][93:95]
        BBW = daten[i][97:99] + daten[i][101:103] 

    if daten[i][0:4] == '#CWB':                               # Wechselbass Belegung fr die C-Reihe ( A-Dur )
        C1W = daten[i][17:19] + daten[i][21:23]
        C2W = daten[i][25:27] + daten[i][29:31]
        C3W = daten[i][33:35] + daten[i][37:39]
        C4W = daten[i][41:43] + daten[i][45:47]
        C5W = daten[i][49:51] + daten[i][53:55]
        C6W = daten[i][57:59] + daten[i][61:63]
        C7W = daten[i][65:67] + daten[i][69:71]
        C8W = daten[i][73:74] + daten[i][77:79]
        C9W = daten[i][81:83] + daten[i][85:87]
        CAW = daten[i][89:91] + daten[i][93:95]
        CBW = daten[i][97:99] + daten[i][101:103]  
    if daten[i][0:4] == '#END':                               # Wenn das Ende der Tabelle fr ein Basssystem erreicht ist

        bass = bass.rstrip()
        bBel = bBel.rstrip()
        
        if instrument == '3':                                
            entry = {bassID:{'Instrument':instrument,'Bass':bass + bBel,
                             'C':{'G':C1W,'Am':C2W,'Bm':C3W,'C':C4W,'D':C5W,'D7':C6W,'Em':C7W,'F#-':C8W,'A7':C9W,'Dx':CAW,'B7':CBW},
                             'B':{'D':B1W,'Em':B2W,'F#m':B3W,'G':B4W,'A':B5W,'A7':B6W,'Bm':B7W,'C#-':B8W,'E7':B9W,'Ax':BAW,'F#7':BBW},
                             'A':{'A':A1W,'Bm':A2W,'C#m':A3W,'D':A4W,'E':A5W,'E7':A6W,'F#m':A7W,'G#-':A8W,'B7':A9W,'Ex':AAW,'C#7':ABW}
                     }}
            wechselBass.update(entry)                           # dann in Directory schreiben
        if instrument == '4':
            entry = {bassID:{'Instrument':instrument,'Bass':bass + bBel,
                             'F':{'C':F1W,'Dm':F2W,'Em':F3W,'F':F4W,'G':F5W,'G7':F6W,'Am':F7W,'B-':F8W,'D7':F9W,'Gx':FAW,'E7':CBW},
                             'C':{'G':C1W,'Am':C2W,'Bm':C3W,'C':C4W,'D':C5W,'D7':C6W,'Em':C7W,'F#-':C8W,'A7':C9W,'Dx':CAW,'B7':CBW},
                             'B':{'D':B1W,'Em':B2W,'F#m':B3W,'G':B4W,'A':B5W,'A7':B6W,'Bm':B7W,'C#-':B8W,'E7':B9W,'Ax':BAW,'F#7':BBW},
                             'A':{'A':A1W,'Bm':A2W,'C#m':A3W,'D':A4W,'E':A5W,'E7':A6W,'F#m':A7W,'G#-':A8W,'B7':A9W,'Ex':AAW,'C#7':ABW}
                     }}
            wechselBass.update(entry)
            #messageBox('ENTRY',str(entry))
            # Abfrage : xx = wechselBass['02']['A']['FD']
            #'C':{C1I:C1W,C2I:C2W,C3I:C3W,C4I:C4W,C5I:C5W,C6I:C6W,C7I:C7W,C8I:C8W,C9I:C9W,CAI:CAW,CBI:CBW},
#messageBox('Wechselbass',str(len(wechselBass)))
#messageBox('Wechselbass',str(wechselBass))
#xx = wechselBass['01']['F']['FZ']
#xx = wechselBass['11']['Bass']
#messageBox('Wechselbass',str(xx))

for sysix in range(activeScore().nSystems()):                       # Bass Griffe und ID aus Melodie lschen
    nStaves = activeScore().system(sysix).nStaves()
    if nStaves == 3:                                                # gibt es eine Melodie-Zeile
        tabix   = nStaves -3                                        # Index zur Melodie-Zeile
        TabVoice = activeScore().system(sysix).staff(tabix).voice(0)# Melodie Stimme
        for i in range(TabVoice.nNoteObjs()):
            note = TabVoice.noteObj(i)
            for k in range(note.nDrawObjs()):                       # und lschen
                d  = note.drawObj(k)
                if d <> 0:
                    if d.has_key('tag'):
                        if d['tag'] == '2086-51':
                            id = d['content']                       # Bass ID merken
                        if d['tag'][0:6] == '2086-3' or d['tag'][0:6] == '2086-4' or d['tag'] == '2086-51':
                            note.deleteDrawObj(k)
                            
for sysix in range(activeScore().nSystems()):                       # Bass ID aus Griffschrift lschen
    nStaves = activeScore().system(sysix).nStaves()
    tabix   = nStaves -2                                            # Index zur Griffschrift Zeile
    TabVoice = activeScore().system(sysix).staff(tabix).voice(0)    # Griffschrift Stimme
    for i in range(TabVoice.nNoteObjs()):
        note = TabVoice.noteObj(i)
        for k in range(note.nDrawObjs()):                           # und lschen
            d  = note.drawObj(k)
            if d <> 0:
                if d.has_key('tag'):
                    if d['tag'] == '2086-51':
                        id = d['content']                           # Bass ID merken
                        note.deleteDrawObj(k)

for sysix in range(activeScore().nSystems()):                       # normales Zeilenende feststellen
    nStaves  = activeScore().system(sysix).nStaves()
    tabix    = nStaves -2                                           # Index zur Griffschrift Zeile
    TabVoice = activeScore().system(sysix).staff(tabix).voice(0)    # Griffschrift Stimme
    just = activeScore().system(sysix).get('justified')
    if just == 1:
        anz = TabVoice.nNoteObjs()-1
        zeilenEndeJust = TabVoice.noteObj(anz).posX()
        break
    else : zeilenEndeJust = 999                                     # Absturz verhindert falls nur Kurzzeilen
    
for sysix in range(activeScore().nSystems()):                       # Zeile falls erforderlich justieren
    nStaves  = activeScore().system(sysix).nStaves()
    tabix    = nStaves -2                                           # Index zur Griffschrift Zeile
    TabVoice = activeScore().system(sysix).staff(tabix).voice(0)    # Griffschrift Stimme
    just = activeScore().system(sysix).get('justified')
    if just == 0:
        anz = TabVoice.nNoteObjs()-1
        zeilenEnde = TabVoice.noteObj(anz).posX()
        if zeilenEnde > zeilenEndeJust:
            activeScore().system(sysix).set('justified',1)
            

options = ScriptOptions() 
opt = options.get()
ft = '0'
tt = '1'
lt = '1'

if opt:
    ft = opt.get('FormatTyp',ft)
    tt = opt.get('TabTyp',tt)
    lt = opt.get('LinTyp',lt)

placeholder1   = Label('       ',width=1)
placeholder2   = Label('     ',width=1)
placeholder3   = Label('   ',width=1)
placeholder4   = Label(' ',width=1)

radFormatTyp  = Radio([tr('msgC01'),tr('msgC02'),tr('msgC03'),tr('msgC17'),tr('msgC18')],text=tr('msgC04'),value=int(opt.get('FormatTyp',str(ft))))
subboxFormat  = HBox([radFormatTyp,placeholder2],padding=4)
mainboxFormat = VBox([subboxFormat],text=tr('msgC05'))

radTabTyp     = Radio([tr('msgC06'),tr('msgC07'),tr('msgC08'),tr('msgC16')],text=tr('msgC09'),value=int(opt.get('TabTyp',str(tt))))
subboxTab     = HBox([radTabTyp,placeholder2],padding=4)
mainboxTab    = VBox([subboxTab],text=tr('msgC10'))

radLinTyp     = Radio([tr('msgC11'),tr('msgC12'),tr('msgC13')],text=tr('msgC14'),value=int(opt.get('LinTyp',str(lt))))
subboxLin     = HBox([radLinTyp,placeholder2],padding=4)
mainboxLin    = VBox([subboxLin],text=tr('msgC15'))

box  = VBox([mainboxFormat,placeholder1,mainboxTab,placeholder1,mainboxLin,placeholder1],padding=1)
dlg  = Dialog('Ziach_C  Version: '+ version,box)
    
if dlg.run():
    ft = radFormatTyp.value()
    tt = radTabTyp.value()
    lt = radLinTyp.value()
    
    opt  = dict(
                  FormatTyp   = str(ft),
                  TabTyp      = str(tt),
                  LinTyp      = str(lt)
                 )
    options.set(opt)
    formatTyp = ft
    TabTyp    = tt
    LinTyp    = lt 
else: exit(0)

druck = 'no'
x1n   = 0
x2n   = 0
y1n   = 0
y2n   = 0
posN  = 0

for sysix in range(activeScore().nSystems()):
    nStaves  = activeScore().system(sysix).nStaves()
    tabix    = nStaves -2                                           # Index zur Griffschrift Zeile
    bglix    = nStaves -1                                           # Index zur Begleitzeile
    TabVoice = activeScore().system(sysix).staff(tabix).voice(0)    # Griffschrift Stimme
    BglVoice = activeScore().system(sysix).staff(bglix).voice(0)    # Begleitstimme 
    position = 0
    meter    = 1                                                    # default Taktlnge = 4/4
    exBar    = 0                                                    # expl.Barline
    noteVal  = 0
                        
    for i in range(TabVoice.nNoteObjs()):        
        note = TabVoice.noteObj(i)
        noteVal = noteVal + note.duration()
        #messageBox('noteVal',str(noteVal))
      
        if note.subType() == NoteObj.METER:                         # Taktangabe als Textobjekt vorbereiten
            meter = note.meter()
            d = dict(type    = 'text',
                     content = '!T' + str(meter))

            for ii in range(TabVoice.nNoteObjs()-i):                # nchste Note oder Pause finden 
                nextNote = TabVoice.noteObj(i+ii)                    
                if nextNote.isChord() or nextNote.isRest():
                    break
                
            nextNote.addDrawObj(d)                                  # Takt an nchste Note oder Pause als Text hngen
            #messageBox('meter',str(meter))
        for k in range(note.nDrawObjs()):                           # falls eine Taktangabe an der Note hngt 
            d       = note.drawObj(k)
            taktTag = 0
            
            if d['type'] == 'text':
                xx = d['content'][0:2]
                if xx == '!T':
                    taktTag = 1                                     # freigeben zum kopieren in die Begleitzeile

            if d.has_key('tag') and d['tag'] <> '2086-52' and d['tag'] <> '2086-53' or taktTag == 1:                    # falls Begleitakkord oder Taktangabe
                #messageBox('Tags',str(d))
                Bposition = 0
                Bnote     = []
                BnoteVal  = 0
                ix        = 0
                notePos = note.posX(False)
                
                for i in range(BglVoice.nNoteObjs()):              
                    Bnote = BglVoice.noteObj(i)
                    BnoteVal = BnoteVal + Bnote.duration()
                    #BnotePos = Bnote.posX(False)
                    
                    if Bnote.isChord() or Bnote.isRest():
                        rNote = note.duration()
                        rBnote = Bnote.duration()
                        while BnoteVal < noteVal:                   # korrekte Begleitnote finden
                            #messageBox('Val1',str(noteVal) + '\n' + str(BnoteVal))
                            ix = ix + 1
                            Bnote = BglVoice.noteObj(i+ix)
                            BnoteVal = BnoteVal + Bnote.duration()
                            rNote = note.duration()
                            rBnote = Bnote.duration()
                            #messageBox('Val2',str(noteVal) + '\n' + str(BnoteVal))
 
                        d['y'] = 2
                        #messageBox('R',str(rNote) + '\n' +str(rBnote) + '\n' + str(Bnote.duration()))
                        if rNote > rBnote:
                            ix1 = 1
                            while rNote > rBnote:
                                Bnote = BglVoice.noteObj(i+ix-ix1)
                                rNote = rNote - rBnote
                                ix1 = ix1 + 1
                        #messageBox('COPY',str(d) + '\n' + str(Bnote.duration()))
                        Bnote.addDrawObj(d)                         # und dranhngen
                        #messageBox('Tags2',str(d))
                        if taktTag == 1:                            # falls Takangabe dann Original lschen
                            note.deleteDrawObj(k)                    
                        break

    
    for i in range(TabVoice.nNoteObjs()):                           # doppelte Druckindikatoren lschen 
        note = TabVoice.noteObj(i)
        orgCount = note.nDrawObjs()
        while orgCount <> 0:
            ct = 0
            d  = 0
            for k in range(note.nDrawObjs()):
                d = note.drawObj(k)
                if d <> 0:
                    if d['type'] == 'line'and d['lineWidth'] == 0.5:
                        ct = ct+1
                        if ct >= 2:
                            note.deleteDrawObj(k)
            orgCount = orgCount-1

    noteDruckStart = 'NA'                                              # Druckbalken optimieren
    posDruckStart  = 'NA'
    noteDruckEnd   = 'NA'                                             
    posDruckEnd    = 'NA'                                               
    posDruckEnd    = 'NA'
    posZugStart    = 'NA'
    TsLinks        = 'NA'
    posTsLinks     = 'NA'
    TsRechts       = 'NA'
    posTsRechts    = 'NA'
    
    for i in range(TabVoice.nNoteObjs()):                              # Druckbalken optimieren
        #messageBox('Loop',str(i) + '\n' + str(TabVoice.nNoteObjs()))
        note = TabVoice.noteObj(i)

        if note.subType() == 5:                                        # fester Taktstrich
            #messageBox('ST',str(note.subType()))
            if noteDruckStart == 'NA':                                 # wenn am Anfang der Zeile
                TsLinks = note
                posTsLinks = note.posX(True)
            else:                                                      # wenn hinter einer Druck Note
                TsRechts = note
                posTsRechts = note.posX(True)
        elif note.subType() == 1 or note.subType() == 0:               # Note oder Pause
            #messageBox('ST',str(note.subType()))
            if isDruck(note) == 1:                                     # nur wenn Druck Note
                if noteDruckStart == 'NA':                             # wenn erste Druck Note
                    noteDruckStart = note                                              
                    posDruckStart  = note.posX(True)
                    if TsLinks == 'NA':                                # falls links kein fester Taktstrich
                        if TabVoice.noteObj(i-1).implBarline() != 0:   # aber ein automatischer Taktstrich  
                            posTsLinks = TabVoice.noteObj(i-1).implBarline().posX()
                        else:
                            posTsLinks = 'NA'
                    if noteDruckEnd == 'NA':
                        noteDruckEnd = noteDruckStart
                        posDruckEnd = posDruckStart
                else:                                                  # wenn Fortsetzungs Druck Note
                    noteDruckEnd = note                                              
                    posDruckEnd  = note.posX(True)
                    
                if note.implBarline() != 0:                            # wenn ein automatischer Taktstrich an der Note hngt
                    TsRechts = note
                    posTsRechts = note.implBarline().posX()
                else:
                    TsRechts = 'NA'
                    posTsRechts = 'NA'
            else:                                                      # wenn Zug Note
                if noteDruckStart == 'NA':
                    if TsLinks <> 'NA':                                # Falls fester Taktstrich am Anfang und die Folgenote ist auf Zug
                        TsLinks = 'NA'                                 # festen Taktstrich zurcksetzen
                        posTsLinks = 'NA'
                else:                                                  #falls Drucknoten vorhanden sind Ausgabe starten
                    posZugStart = note.posX()
                    for ii in range(BglVoice.nNoteObjs()):                        
                        Bnote = BglVoice.noteObj(ii)
                        posBglNote  = Bnote.posX(True)
                        if posBglNote >= posZugStart and TsRechts == 'NA':
                            Lnote = BglVoice.noteObj(ii-1)
                            posLNote= Lnote.posX(True)
                            delta = (posBglNote - posLNote) / 2
                            posDruckEnd = posBglNote -  delta
                            break
                    lineOutput()

        if noteDruckStart <> 'NA' and TabVoice.nNoteObjs() == i+1:     # falls Ende der Zeile, Ausgabe starten
            lineOutput()

#messageBox('Trap','Begleitakkorde lschen')

for sysix in range(activeScore().nSystems()):                       # Begleitakkorde aus Griffschrift lschen
    nStaves = activeScore().system(sysix).nStaves()
    tabix   = nStaves -2                                            # Index zur Griffschrift Zeile
    TabVoice = activeScore().system(sysix).staff(tabix).voice(0)    # Griffschrift Stimme
    for i in range(TabVoice.nNoteObjs()):
        note = TabVoice.noteObj(i)
        for k in range(note.nDrawObjs()):                           # und lschen
            d  = note.drawObj(k)
            if d <> 0:
                if d.has_key('tag') and d['tag'] <> '2086-52' and d['tag'] <> '2086-53':
                    note.deleteDrawObj(k)

meter = 1                                                           # Default Takt = 4/4
ba    = ' '
yy    = ' '
ct    = 1

#messageBox('Trap','Begleitung ergnzen')
wb = ' '                                                            # Wechselbass initialisieren um Absturz zu vermeiden
for sysix in range(activeScore().nSystems()):                       # Begleitung in Begleitzeile ergnzen
    nStaves = activeScore().system(sysix).nStaves()
    tabix   = nStaves -1                                            # Index zur Griffschrift Zeile
    BglVoice = activeScore().system(sysix).staff(tabix).voice(0)    # Griffschrift Stimme

    for i in range(BglVoice.nNoteObjs()):
        #messageBox('BGL1',str(i))
        am   = 'no'                                                 # kein Akkordwechsel
        note = BglVoice.noteObj(i)
        if note.isChord() or note.isRest():
            komplett = 0
            #messageBox('BGL',str(i))
            for ii in range(note.nDrawObjs()):
                d = note.drawObj(ii)
                #messageBox('BGL2',str(d))
                if d <> 0:
                    if d['type'] == 'text':
                        xx = d['content'][0:2]
                        if xx == '!T':
                            yy = d['content']                       # =Begleitakkord
                            fT = d['font']
                            fG = fT['height']
                            meter = d['content'][2:]                # Takt extrahieren
                            #note.deleteDrawObj(ii)                  # und Taktmerker lschen
                            break
                            
    for i in range(BglVoice.nNoteObjs()):
        #messageBox('BGL',str(i))
        am   = 'no'                                                 # kein Akkordwechsel
        note = BglVoice.noteObj(i)
        if note.isChord() or note.isRest():
            komplett = 0
            #('BGL1',str(i))
            for ii in range(note.nDrawObjs()):
                d = note.drawObj(ii)
                #messageBox('BGL2',str(d))
                if d <> 0:
                    if d['type'] == 'text':
                        xx = d['content'][0:2]
                        if xx == '!T':
                            #yy = d['content']                      # =Begleitakkord
                            #fT = d['font']
                            #fG = fT['height']
                            meter = d['content'][2:]                # Takt extrahieren                   <- wird bentigt, damit das erste meter korrekt initialisiert ist
                            note.deleteDrawObj(ii)                  # und Taktmerker lschen  
                    if d.has_key('tag'):                            # Akkordwechsel gefunden
                        if d['tag'] == '2086-50':                   # Begleitakkord merken
                            xchord = d['content']
                            komplett = komplett + 1
                            #messageBox('XCHORD',str(xchord) + '\n' + str(komplett))
                            
                        elif d['tag'] <> '2086-52' and d['tag'] <> '2086-53' and d['tag'] <> '2085-50' and d['tag'] <> '2085-51':
                            am = 'gefunden'                         # und merken
                            wi = 0                                  # Wechselbass Index zum 1.Bass setzen
                            wl = 2                                  # Wechselbass Index Ende 
                            yy = d['content']                       # =Begleitakkord
                            tg = d['tag']
                            fT = d['font']
                            fG = fT['height']
                            #messageBox('fG',str(fG) + '***' + str(fT))
                            if tg[6] == '1': reihe = 'C'            # Reihe extrahieren
                            elif tg[6] == '2': reihe = 'B'
                            elif tg[6] == '3': reihe = 'A'
                            elif tg[6] == '4': reihe = 'F'
                            komplett = komplett + 1
                            dMerker = d
                            iMerker = ii
                            #messageBox('CHORD',str(yy) + '\n' + str(komplett))
                            
                if komplett == 2 and yy <> '-':
                        komplett = 0
                        #messageBox('WB',str(id) + '\n' + str(reihe) + '\n' +str(xchord))
                        #messageBox('WB',str(id) + '\n' + str(reihe))
                        wb = wechselBass[id][reihe][xchord]  # Wechselbass auslesen
                        
                        forceBassOnly = 0                    # kontrollieren ob nur der Grundbass aber kein dazugehriger Akkord vorhanden ist
                        if str(wb[2:3]) == '-':
                            forceBassOnly = 1
                          
                        #messageBox('WB',str(wb) + '\n'  + str(wb[2:3]) + '\n' + str(id) + '\n' + str(reihe) + '\n' +str(xchord))
                        yy = yy.strip()
                        #messageBox('LEN',str(len(yy)))
                        yyBasis = yy[0:1]
                        if len(yy) == 2:
                            yyRest  = yy[1:2]

                        if yyBasis <> '-':                           # nur Begleitakkorde durchlassen
                            Begleitung  =  dict(
                                            A = dict(wert='a'),
                                            B = dict(wert='b'),
                                            C = dict(wert='c'),
                                            D = dict(wert='d'),
                                            E = dict(wert='e'),
                                            F = dict(wert='f'),
                                            G = dict(wert='g'),
                                            H = dict(wert='h')
                                            )
                            if forceBassOnly == 1:
                                ba = '-'
                            else:
                                ba = Begleitung[str(yyBasis)]['wert']    # Begleitakkord merken
                            if len(yy) == 2:
                                ba = ba + yyRest

                            #messageBox('WB','WB=' + str(wb) + '\nBA=' + str(ba) + '\nCH=' + str(xchord) + '\nFT=' + str(formatTyp))
                                    
                            ct = 1                                   # Bass
                            d = dMerker
                            if formatTyp == 3 or formatTyp == 4:     # Wechselbass Typ 1
                                d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                        font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                                note.replaceDrawObj(iMerker,d)
                                if forceBassOnly == 0:
                                    wi = 2
                                    wl = 4
                        else:
                            ba = '-'                                 # Dummy Akkorde durch Leerzeichen ersetzen
                            yy = '-'
                            wb = '--'
                            d = dMerker
                            d['content'] = '-'
                            note.replaceDrawObj(iMerker,d)
            #messageBox('WB',str(yy) + ' / ' + str(ba))
                    
            if am == 'no':
                
                #messageBox('ft?' ,'ft = ' + str(formatTyp) + '   meter = ' + str(meter) + '    Cnt=' + str(ct) + '   ba=' + str(ba))
                duration = str(note.duration())
                d = dict(type = 'text',y = 2,content = str(ba),
                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                #messageBox('ft?' ,'ft = ' + str(formatTyp) + '   meter = ' + str(meter) + '    Cnt=' + str(ct) + '   ba=' + str(ba)+ '   duration=' + str(duration) + '\n' + str(d))  
                if formatTyp == 1:                                  # Format Typ 1 = Aaa , Aaaa, Aaaaaa etc
                    #messageBox('ft?' ,'ft = ' + str(formatTyp) + '   meter = ' + str(meter) + '    Cnt=' + str(ct) + '   ba=' + str(ba))
                    if duration == str('1/8'):                      # 8tel Begleitung
                        #messageBox('am=n0 ,str(meter) + '    Cnt=' + str(ct) + '\nyy=' + str(yy) + '   ba=' + str(ba))
                        ct = ct + 1
                        if meter == str('1') and ct <= 8:           # 4/4 tel Takt
                            d = dict(type = 'text',y = 2,content = str(ba),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            
                        elif meter == str('2/4') or meter == str('1/2'):  # 2/4 tel Takt                            
                            if ct == 1:                             # 2/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(yy),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            elif ct == 4:                           # 2/4 tel Takt zweite Hlfte
                                ct = 0
                            
                        elif meter == str('3/4'):                   # 3/4 tel Takt
                            if ct == 1:                             # 3/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(yy),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            elif ct == 6:                           # 3/4 tel Takt zweite Hlfte
                                ct = 0                              
                            
                        note.addDrawObj(d)
                        
                    elif duration == str('1/4'):                    # 4tel Begleitung
                        #messageBox('ft?' ,'ft = ' + str(formatTyp) + '   meter = ' + str(meter) + '    Cnt=' + str(ct) + '   ba=' + str(ba))    
                        ct = ct + 1
                        if meter == str('1') and ct == 1:           # 4/4 tel Takt erste Hlfte
                            d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            if wi == 0:
                                wi = 2
                                wl = 4
                            note.addDrawObj(d)
                            
                        elif meter == str('1') and ct <= 4:           # 4/4 tel Takt    
                            d = dict(type = 'text',y = 2,content = str(ba),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            
                        elif meter == str('2/4') or meter == str('1/2'):  # 2/4 tel Takt                            
                            if ct == 1:                             # 2/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(yy),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            elif ct == 2:                           # 3/4 tel Takt zweite Hlfte
                                ct = 0             
                            
                        elif meter == str('3/4'):                   # 3/4 oder 6/8 tel Takt
                            if ct == 1:                             # 3/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(yy),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            elif ct == 3:                           # 3/4 tel Takt zweite Hlfte
                                ct = 0                              

                        note.addDrawObj(d)
                    
                elif formatTyp == 2:                                # Format Typ 2 = Aaa , AaAa, AaaAaa etc
                    
                    skipFlag = 0    
                    if duration == str('1/8'):                      # 8tel Begleitung
                        #messageBox('Begleitstimme' ,str(meter) + '    Cnt=' + str(ct) + '\nyy=' + str(yy) + '   ba=' + str(ba))

                        ct = ct + 1
                        #messageBox('WB Typ2 ct',str(ct))
                        if meter == str('1') and ct <= 4:           # 4/4 tel Takt erste Hlfte
                            x = 1                                   # Dummy Operation
                        elif meter == str('1') and ct == 5:         # 4/4 tel Takt zweite Hlft
                            d = dict(type = 'text',y = 2,content = str(yy),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            note.addDrawObj(d)
                            skipFlag = 1
                            d = dict(type = 'text',y = 2,content = str(ba),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            ct = 1
                            
                        elif meter == str('2/4') or meter == str('1/2'): # 2/4 tel Takt
                            if ct == 1:                             # 2/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(yy),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            elif ct == 2:                           # 2/4 tel Takt zweite Hlfte
                                ct = 0
                                
                        elif meter == str('3/4') and ct == 1:       # 6/8 tel Takt erste Hlfte
                            d = dict(type = 'text',y = 2,content = str(yy),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            note.addDrawObj(d)
                            skipFlag = 1
                            
                        elif meter == str('3/4') and ct == 4:       # 6/8 tel Takt zweite Hlfte
                            d = dict(type    = 'text',
                                     y       = 2,
                                     content = str(yy),
                                     font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            note.addDrawObj(d)
                            skipFlag = 1
                            #messageBox('WB Typ2 3/4 B',str(d) + '\n' + str(ct))
                            d = dict(type = 'text', content = str(ba),
                                     font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            ct = 1
                        if skipFlag == 0:
                            note.addDrawObj(d)
                            #messageBox('WB Typ2 immer',str(d) + '\n' + str(ct))
                        skipFlag = 0

                    elif duration == str('1/4'):                    # 4tel Begleitung
                        #messageBox('Begleitstimme' ,str(meter) + '    Cnt=' + str(ct) + '\nyy=' + str(yy) + '   ba=' + str(ba))
                        ct = ct + 1
                        if meter == str('1') and ct == 1:           # 4/4 tel Takt erste Hlfte
                            d = dict(type = 'text',y = 2,content = str(yy),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            note.addDrawObj(d)
                             
                        elif meter == str('1') and ct == 3:         # 4/4 tel Takt zweite Hlfte
                            d = dict(type = 'text',y = 2,content = str(yy),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            note.addDrawObj(d)
                            d = dict(type = 'text',y = 2,content = str(ba),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            ct = 1
                            
                        elif meter == str('2/4') or meter == str('1/2'):  # 2/4 tel Takt
                            if ct == 1:                             # 2/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(yy),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            elif ct == 2:                           # 2/4 tel Takt zweite Hlfte
                                ct = 0

                        elif meter == str('3/4'):                   # 3/4 tel Takt
                            if ct == 1:                             # 3/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(yy),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                                note.addDrawObj(d)
                            elif ct == 3:                           # 3/4 tel Takt zweite Hlfte
                                ct = 0
                                
                        if ct <> 1:  
                            note.addDrawObj(d)
                          
                elif formatTyp == 3 and wb <> ' ':                    # Format Typ 3 = Aaa , Aaaa, Aaaaaa etc und Wechselbass
                    #messageBox('ft3' ,'meter = ' + str(meter) + '    Cnt=' + str(ct) + '   ba=' + str(ba))
                    if duration == str('1/8'):                      # 8tel Begleitung
                        #messageBox('am=n0 ,str(meter) + '    Cnt=' + str(ct) + '\nyy=' + str(yy) + '   ba=' + str(ba))
                        ct = ct + 1
                        if meter == str('1') and ct <= 8:           # 4/4 tel Takt
                            d = dict(type = 'text',y = 2,content = str(ba),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            
                        elif meter == str('2/4') or meter == str('1/2'):  # 2/4 tel Takt                            
                            if ct == 1:                             # 2/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                                if wi == 0:
                                    wi = 2
                                    wl = 4
                                else:
                                    wi = 0
                                    wl = 2
                            elif ct == 4:                           # 2/4 tel Takt zweite Hlfte
                                ct = 0
                            
                        elif meter == str('3/4'):                   # 3/4 tel Takt
                            if ct == 1:                             # 3/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                                if wi == 0:
                                    wi = 2
                                    wl = 4
                                else:
                                    wi = 0
                                    wl = 2
                                
                            elif ct == 6:                           # 3/4 tel Takt zweite Hlfte
                                ct = 0                              
                            
                        note.addDrawObj(d)
                        
                    elif duration == str('1/4'):                    # 4tel Begleitung

                        ct = ct + 1
                        if meter == str('1') and ct == 1:           # 4/4 tel Takt erste Hlfte
                            d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            if wi == 0:
                                wi = 2
                                wl = 4
                            note.addDrawObj(d)
                            
                        elif meter == str('1') and ct <> 1:           # 4/4 tel Takt    
                            d = dict(type = 'text',y = 2,content = str(ba),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            
                        elif meter == str('2/4') or meter == str('1/2'):  # 2/4 tel Takt                            
                            if ct == 1:                             # 2/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                                if wi == 0:
                                    wi = 2
                                    wl = 4
                                else:
                                    wi = 0
                                    wl = 2
                            elif ct == 2:                           # 3/4 tel Takt zweite Hlfte
                                ct = 0             
                            
                        elif meter == str('3/4'):                   # 3/4 oder 6/8 tel Takt
                            if ct == 1:                             # 3/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                                if wi == 0:
                                    wi = 2
                                    wl = 4
                                else:
                                    wi = 0
                                    wl = 2
                            elif ct == 3:                           # 3/4 tel Takt zweite Hlfte
                                ct = 0                              

                        note.addDrawObj(d)
                
                elif formatTyp == 4 and wb <> ' ':                  # Format Typ 2 = Aaa , AaBa, AaaBaa etc - Wechselbass
                    skipFlag = 0
                    #messageBox('ft2?' ,'ft = ' + str(formatTyp) + '   meter = ' + str(meter) + '    Cnt=' + str(ct) + '   ba=' + str(ba)+ '   duration=' + str(duration) + '\n' + str(d))  
                    if duration == str('1/8'):                      # 8tel Begleitung
                        #messageBox('Begleitstimme' ,str(meter) + '    Cnt=' + str(ct) + '\nyy=' + str(yy) + '   ba=' + str(ba))
                        ct = ct + 1
                        
                        if meter == str('1') and ct <= 4:           # 4/4 tel Takt erste Hlfte
                            x = 1                                   # Dummy Operation
                        elif meter == str('1') and ct == 5:         # 4/4 tel Takt zweite Hlft
                            d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            if wi == 0:
                                wi = 2
                                wl = 4
                            else:
                                wi = 0
                                wl = 2
                            note.addDrawObj(d)
                            skipFlag = 1
                            d = dict(type = 'text',y = 2,content = str(ba),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            ct = 1
                            
                        elif meter == str('2/4') or meter == str('1/2'): # 2/4 tel Takt
                            if ct == 1:                             # 2/4 tel Takt erste Hlfte
                                #messageBox('WB',str(wb))
                                d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                                if wi == 0:
                                    wi = 2
                                    wl = 4
                                else:
                                    wi = 0
                                    wl = 2
                            elif ct == 2:                           # 2/4 tel Takt zweite Hlfte
                                ct = 0
                                
                        elif meter == str('3/4') and ct == 1:         # 6/8 tel Takt erste Hlfte
                            d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            if wi == 0:
                                wi = 2
                                wl = 4
                            else:
                                wi = 0
                                wl = 2
                            note.addDrawObj(d)
                            
                        elif meter == str('3/4') and ct == 4:       # 6/8 tel Takt zweite Hlfte
                            d = dict(type    = 'text',
                                     y       = 2,
                                     content = str(wb[wi:wl]),
                                     font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            if wi == 0:
                                wi = 2
                                wl = 4
                            else:
                                wi = 0
                                wl = 2
                            note.addDrawObj(d)
                            skipFlag = 1
                            d = dict(type = 'text', content = str(ba),
                                     font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            ct = 1
                                
                        if skipFlag == 0:
                            note.addDrawObj(d)
                        skipFlag = 0
                            
                    elif duration == str('1/4'):                    # 4tel Begleitung
                        #messageBox('Begleitstimme' ,str(meter) + '    Cnt=' + str(ct) + '\nyy=' + str(yy) + '   ba=' + str(ba))
                        ct = ct + 1
                        
                        if meter == str('1') and ct == 1:           # 4/4 tel Takt erste Hlfte
                            d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            if wi == 0:
                                wi = 2
                                wl = 4
                            note.addDrawObj(d)
                                
                        elif meter == str('1') and ct == 3:         # 4/4 tel Takt zweite Hlfte
                            d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            if wi == 0:
                                wi = 2
                                wl = 4
                            else:
                                wi = 0
                                wl = 2
                            note.addDrawObj(d)
                            d = dict(type = 'text',y = 2,content = str(ba),
                                    font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                            ct = 1
                            
                        elif meter == str('2/4') or meter == str('1/2'):  # 2/4 tel Takt
                            if ct == 1:                             # 2/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                                if wi == 0:
                                    wi = 2
                                    wl = 4
                                else:
                                    wi = 0
                                    wl = 2
                            elif ct == 2:                           # 2/4 tel Takt zweite Hlfte
                                ct = 0

                        elif meter == str('3/4'):                   # 3/4 tel Takt
                            if ct == 1:                             # 3/4 tel Takt erste Hlfte
                                d = dict(type = 'text',y = 2,content = str(wb[wi:wl]),
                                         font = dict(height = fG, pitchAndFamily = 0, face = 'Times New Roman', weight = 0))
                                if wi == 0:
                                    wi = 2
                                    wl = 4
                                else:
                                    wi = 0
                                    wl = 2
                            elif ct == 3:                           # 3/4 tel Takt zweite Hlfte
                                ct = 0
  
                        #messageBox('spill',str(d))
                        if meter == str('3/4'):
                            note.addDrawObj(d)
                        elif ct <> 1:
                            note.addDrawObj(d)

        else:
            ct = 0
    for i in range(BglVoice.nNoteObjs()):
        #messageBox('BGL1',str(i))
        note = BglVoice.noteObj(i)
        if note.isChord() or note.isRest():
            #messageBox('BGL',str(i))
            for ii in range(note.nDrawObjs()):
                d = note.drawObj(ii)
                #messageBox('BGL2',str(d))
                if d <> 0:
                    if d['type'] == 'text':
                        xx = d['content'][0:2]
                        if xx == '!T':
                            note.deleteDrawObj(ii)                  # und Taktmerker lschen
                            
#Tabulatur Zeichen einfgen

for sysix in range(activeScore().nSystems()):                       # Tabulatur Zeichen einfgen und
                                                                    # Verbindungslinie unterdrcken
    nStaves = activeScore().system(sysix).nStaves()
    tabix   = nStaves -2                                            # Index zur Griffschrift Zeile
    TabVoice = activeScore().system(sysix).staff(tabix).voice(0)    # Griffschrift Stimme
    aa = activeScore().system(sysix).getAttributes()
    for i in range(TabVoice.nNoteObjs()):
        note = TabVoice.noteObj(i)
        if note.isChord() or note.isRest():
            pos = note.posX(1)
            
            l1 = dict(type = 'line',x1 = pos*-1,x2 = pos*-1,y1=-2.2,y2=12.5,lineWidth = 0.6, color=Color.white)
            l2 = dict(type = 'line',x1 = pos*-1,x2 = pos*-1,y1=2,y2=12.5,lineWidth = 0.6, color=Color.white)
            if LinTyp == 1:                
                note.addDrawObj(l1)                                 # Linie weg
            if LinTyp == 2:
                note.addDrawObj(l2)
            
            t1 = dict(type = 'text',y = 0.5,x = pos*-1+0.8,content = 'A',
                font = dict(height = 18, pitchAndFamily = 2, charSet = 2, face = 'Ziach', weight = 10))
            t2 = dict(type = 'text',y = 1.5,x = pos*-1+0.8,content = 'B',
                font = dict(height = 18, pitchAndFamily = 2, charSet = 2, face = 'Ziach', weight = 10))
            t3 = dict(type = 'text',y = 0.5,x = pos*-1+0.8,content = 'E',
                font = dict(height = 18, pitchAndFamily = 2, charSet = 2, face = 'Ziach', weight = 10))

            if TabTyp == 1:                                         # kleines TAB
                note.addDrawObj(t2)
            elif TabTyp == 2:                                       # groes TAB
                note.addDrawObj(t1)
            elif TabTyp == 3:                                       # h TAB
                note.addDrawObj(t3)
            break

for sysix in range(activeScore().nSystems()):                       # Begleitakkorde aus Griffschrift lschen
    nStaves = activeScore().system(sysix).nStaves()
    tabix   = nStaves -2                                            # Index zur Griffschrift Zeile
    TabVoice = activeScore().system(sysix).staff(tabix).voice(0)    # Griffschrift Stimme
    for i in range(TabVoice.nNoteObjs()):
        note = TabVoice.noteObj(i)
        for k in range(note.nDrawObjs()):                           # und lschen
            d  = note.drawObj(k)
            if d <> 0:
                if d.has_key('tag'):
                    if d['tag'] == '2086-50':
                        note.deleteDrawObj(k)

        #nur wenn Melodiezeile
        if nStaves > 2:
            for k in range(note.nDrawObjs()):                       # und lschen
                d  = note.drawObj(k)
                if d <> 0:
                    if d.has_key('tag'):
                        if d['tag'] == '2086-52':
                            note.deleteDrawObj(k)
            for k in range(note.nDrawObjs()):                       # und lschen
                d  = note.drawObj(k)
                if d <> 0:
                    if d.has_key('tag'):
                        if d['tag'] == '2086-53':
                            note.deleteDrawObj(k)

for sysix in range(activeScore().nSystems()):                       # Begleitakkorde aus Griffschrift Zeile 2 lschen
    nStaves = activeScore().system(sysix).nStaves()
    tabix   = nStaves -1                                            # Index zur Griffschrift Zeile
    TabVoice = activeScore().system(sysix).staff(tabix).voice(0)    # Griffschrift Stimme
    for i in range(TabVoice.nNoteObjs()):
        note = TabVoice.noteObj(i)
        for k in range(note.nDrawObjs()):                           # und lschen
            d  = note.drawObj(k)
            if d <> 0:
                if d.has_key('tag'):
                    if d['tag'] == '2086-50':
                        note.deleteDrawObj(k)

for sysix in range(activeScore().nSystems()):                           # V nach DD x entfernen falls Melodiestimme
    nStaves = activeScore().system(sysix).nStaves()
    if nStaves > 2:
        tabix   = nStaves -3                                            # Index zur Melodie Zeile
        TabVoice = activeScore().system(sysix).staff(tabix).voice(0)       
        for i in range(TabVoice.nNoteObjs()):
            note = TabVoice.noteObj(i)
            for k in range(note.nDrawObjs()):                            
                d  = note.drawObj(k)
                if d <> 0:
                    if d.has_key('tag'):
                        if d['tag'] == '2086-50':
                            acc = d['content']
                            if acc == 'Gx':
                                acc = 'G'
                                d['content'] = acc
                                note.replaceDrawObj(k,d)
                            elif acc == 'Dx':
                                acc = 'D'
                                d['content'] = acc
                                note.replaceDrawObj(k,d)
                            elif acc == 'Ax':
                                acc = 'A'
                                d['content'] = acc
                                note.replaceDrawObj(k,d)
                            elif acc == 'Ex':
                                acc = 'E'
                                d['content'] = acc
                                note.replaceDrawObj(k,d)
                        
#27.09.2006 Verbesserte Darstellung bei Sekundabstnden
for sysix in range(activeScore().nSystems()):                       # normales Zeilenende feststellen
    nStaves  = activeScore().system(sysix).nStaves()
    tabix    = nStaves -2                                           # Index zur Griffschrift Zeile
    TabVoice = activeScore().system(sysix).staff(tabix).voice(0)    # Griffschrift Stimme
    for i in range(TabVoice.nNoteObjs()):                           # Bei Sekundabstnden und Kreuz, dieses verschieben     
        note = TabVoice.noteObj(i)
        if note.isChord():
            p1         = 0
            p2         = 0
            verschoben = 0
            for j in range(note.nHeads()):
                dPitch = note.head(j).diatonicPitch()
                p1 = int(dPitch[0])
                dP = p1 - p2
                if dP == 1 or dP == -1:                             # Sekundabstand feststellen
                    du = note.duration()
                    if du == 0.25 or du == 0.125 or du == 0.0625:   # nur bei 1/4,1/8 und 1/16 
                        du = 'shift'
                    else: du = 'noshift'
                    for k in range(note.nDrawObjs()):                            
                        d = note.drawObj(k)
                        if d['type'] == 'text'and d['content'] and du == 'shift' and verschoben == 0:
                            if d['x'] == 0:                         # bei klassischer Darstellung ignorieren, Kreuzposition nicht 0
                                d['x'] = 1.1
                                note.replaceDrawObj(k,d)
                                verschoben = 1
                p2 = p1


